/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.LinkedList;
import org.igv.Globals;
import org.igv.feature.LocAndVal;

public class ShapeFileUtils {
    static LinkedList<LocAndVal> transformProfile(LinkedList<LocAndVal> profile, int seqLen, int newLeft, String strand) {
        LinkedList<LocAndVal> transProfile = new LinkedList<LocAndVal>();
        for (LocAndVal d : profile) {
            int loc = d.loc;
            double val = d.val;
            if (strand == "+") {
                loc = loc + newLeft - 1;
            } else if (strand == "-") {
                loc = seqLen - loc + newLeft;
            } else {
                throw new RuntimeException("Unrecognized strand (options: \"+\",\"-\")");
            }
            transProfile.add(new LocAndVal(loc, val));
        }
        return transProfile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static LinkedList<LocAndVal> loadShape(String inFile) throws FileNotFoundException, IOException {
        LinkedList<LocAndVal> profile = new LinkedList<LocAndVal>();
        try (BufferedReader br = null;){
            String nextLine;
            br = new BufferedReader(new FileReader(inFile));
            while ((nextLine = br.readLine()) != null) {
                String[] s = Globals.whitespacePattern.split(nextLine.trim());
                int loc = Integer.parseInt(s[0]);
                double val = Double.parseDouble(s[1]);
                if (val < -998.0) {
                    val = Double.NaN;
                }
                profile.add(new LocAndVal(loc, val));
            }
        }
        return profile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void writeWigFile(String wigFile, String chrom, LinkedList<LocAndVal> profile) throws IOException {
        try (PrintWriter pw = null;){
            pw = new PrintWriter(new BufferedWriter(new FileWriter(wigFile)));
            pw.println("variableStep chrom=" + chrom);
            for (LocAndVal d : profile) {
                int loc = d.loc;
                double val = d.val;
                if (Double.isNaN(val)) continue;
                pw.println(loc + "\t" + String.format("%.6f", val));
            }
        }
    }

    public static void shapeToWigFile(String inFile, String wigFile, String chromosome, String strand, int left) throws FileNotFoundException, IOException {
        LinkedList<LocAndVal> profile = ShapeFileUtils.loadShape(inFile);
        profile = ShapeFileUtils.transformProfile(profile, profile.size(), left, strand);
        ShapeFileUtils.writeWigFile(wigFile, chromosome, profile);
    }
}

