/*
 * Decompiled with CFR 0.152.
 */
package org.igv.feature;

import htsjdk.tribble.Feature;
import htsjdk.tribble.readers.AsciiLineReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.Mutation;
import org.igv.feature.genome.Genome;
import org.igv.feature.tribble.MUTCodec;
import org.igv.feature.tribble.TribbleIndexNotFoundException;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.FeatureCollectionSource;
import org.igv.track.FeatureSource;
import org.igv.track.FeatureTrack;
import org.igv.track.MutationFeatureSource;
import org.igv.track.MutationTrack;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;

public class MutationTrackLoader {
    private static Logger log = LogManager.getLogger(MutationTrackLoader.class);
    private ResourceLocator locator = null;
    private Genome genome = null;

    public static boolean isMutationAnnotationFile(ResourceLocator locator) throws IOException {
        return MUTCodec.isMutationAnnotationFile(locator);
    }

    public List<FeatureTrack> loadMutationTracks(ResourceLocator locator, Genome genome) throws IOException, TribbleIndexNotFoundException {
        this.locator = locator;
        this.genome = genome;
        ArrayList<FeatureTrack> tracks = new ArrayList<FeatureTrack>();
        MutationFeatureSource.MutationDataManager dataManager = new MutationFeatureSource.MutationDataManager(locator, genome);
        String[] samples = dataManager.getSamples();
        if (dataManager.isIndexed() && samples != null) {
            for (String sampleId : samples) {
                String id = locator.getPath() + "_" + sampleId;
                MutationFeatureSource featureSource = new MutationFeatureSource(sampleId, dataManager);
                MutationTrack track = new MutationTrack(locator, id, (FeatureSource)featureSource);
                tracks.add(track);
                track.setName(sampleId);
            }
        } else {
            Map<String, List<Feature>> features = this.loadMutations();
            for (String sampleId : features.keySet()) {
                String id = locator.getPath() + "_" + sampleId;
                MutationTrack track = new MutationTrack(locator, id, (FeatureSource)new FeatureCollectionSource((Iterable<? extends Feature>)features.get(sampleId), genome));
                tracks.add(track);
                track.setName(sampleId);
            }
        }
        for (FeatureTrack track : tracks) {
            track.setSquishedRowHeight(5);
            track.setExpandedRowHeight(15);
            track.setHeight(15);
            track.setMinimumHeight(0);
        }
        this.locator = null;
        this.genome = null;
        return tracks;
    }

    private Map<String, List<Feature>> loadMutations() {
        String nextLine = null;
        try (AsciiLineReader reader = null;){
            MUTCodec codec = new MUTCodec(this.locator.getPath(), this.genome);
            LinkedHashMap<String, List<Feature>> mutationMap = new LinkedHashMap<String, List<Feature>>();
            reader = ParsingUtils.openAsciiReader(this.locator);
            while ((nextLine = reader.readLine()) != null && nextLine.startsWith("#")) {
            }
            while ((nextLine = reader.readLine()) != null) {
                Mutation mut = codec.decode(nextLine);
                if (mut == null) continue;
                String sampleId = mut.getSampleId();
                ArrayList<Mutation> features = (ArrayList<Mutation>)mutationMap.get(sampleId);
                if (features == null) {
                    features = new ArrayList<Mutation>();
                    mutationMap.put(sampleId, features);
                }
                features.add(mut);
            }
            LinkedHashMap<String, List<Feature>> linkedHashMap = mutationMap;
            return linkedHashMap;
        }
    }
}

