/*
 * Decompiled with CFR 0.152.
 */
package org.igv.blast;

import java.awt.Color;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.igv.blast.AbstractMapping;
import org.igv.blast.Anchor;
import org.igv.util.ChromosomeColors;

public class Region
extends AbstractMapping {
    List<Anchor> anchors = new ArrayList<Anchor>();

    public void addAnchor(Anchor a) {
        String fromDirection = "+";
        String fromChr = this.getFromChr();
        String toDirection = a.getDirection() ? "+" : "-";
        String toChr = a.getToChr();
        if (this.anchors.size() > 0) {
            Anchor lastAnchor = this.anchors.get(this.anchors.size() - 1);
            int lastFromEnd = lastAnchor.getFromEnd();
            int lastToEnd = lastAnchor.getToEnd();
            Anchor fillerAnchor = new Anchor();
            int fromStart = lastFromEnd;
            int fromEnd = a.getFromStart();
            int toStart = lastToEnd;
            int toEnd = a.getToStart();
            if (toEnd > toStart && fromEnd > fromStart) {
                fillerAnchor.setParameters("psueudo", fromChr, fromStart, fromEnd, fromDirection, toChr, lastToEnd, a.getToStart(), toDirection);
                fillerAnchor.psuedo = true;
                this.anchors.add(fillerAnchor);
            }
        }
        this.anchors.add(a);
    }

    public List<Anchor> getAnchors() {
        return this.anchors;
    }

    @Override
    public double mapPosition(int position) {
        for (Anchor a : this.anchors) {
            if (!a.containsFromPosition(position)) continue;
            return a.mapPosition(position);
        }
        if (this.containsFromPosition(position)) {
            double delta = this.scaleFactor * (double)(position - this.fromStart);
            if (this.direction) {
                return (double)this.toStart + delta;
            }
            return (double)this.toEnd - delta;
        }
        return -1.0;
    }

    public String toBed() {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        String name = this.getToChr() + ":" + this.getToStart() + "-" + this.getToEnd();
        int blockCount = 0;
        Object blockSizes = "";
        Object blockStarts = "";
        for (Anchor a : this.anchors) {
            if (a.psuedo) continue;
            ++blockCount;
            blockSizes = (String)blockSizes + (a.getFromEnd() - a.getFromStart()) + ",";
            blockStarts = (String)blockStarts + (a.getFromStart() - this.getFromStart()) + ",";
        }
        pw.print(this.getFromChr() + "\t" + this.getFromStart() + "\t" + this.getFromEnd() + "\t" + name + "\t1000\t" + (this.getDirection() ? "+" : "-") + "\t" + this.getFromStart() + "\t" + this.getFromEnd() + "\t" + Region.convertColorToRGBString(ChromosomeColors.getColor(this.getToChr())) + "\t" + blockCount + "\t" + (String)blockSizes + "\t" + (String)blockStarts);
        return sw.toString();
    }

    public static String convertColorToRGBString(Color color) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(color.getRed());
        buffer.append(",");
        buffer.append(color.getGreen());
        buffer.append(",");
        buffer.append(color.getBlue());
        return buffer.toString();
    }
}

