/*
 * Decompiled with CFR 0.152.
 */
package org.igv.bedpe;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import org.igv.bedpe.BedPE;
import org.igv.bedpe.InteractionSource;
import org.igv.track.FeatureSource;

public class WrappedInteractionSource
implements InteractionSource {
    FeatureSource<BedPE> featureSource;

    public WrappedInteractionSource(FeatureSource<BedPE> featureSource) {
        this.featureSource = featureSource;
    }

    @Override
    public List<BedPE> getFeatures(String chr, int start, int end, double bpPerPixel, String normalization, int maxFeatureCount) throws IOException {
        Iterator<BedPE> featureIterator = this.featureSource.getFeatures(chr, start, end);
        ArrayList<BedPE> reservoir = new ArrayList<BedPE>();
        if (featureIterator == null) {
            return reservoir;
        }
        if (maxFeatureCount <= 0) {
            while (featureIterator.hasNext()) {
                reservoir.add(featureIterator.next());
            }
            return reservoir;
        }
        int i = 0;
        while (featureIterator.hasNext()) {
            BedPE item = featureIterator.next();
            if (i < maxFeatureCount) {
                reservoir.add(item);
            } else {
                int r = ThreadLocalRandom.current().nextInt(i + 1);
                if (r < maxFeatureCount) {
                    reservoir.set(r, item);
                }
            }
            ++i;
        }
        return reservoir;
    }
}

