/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.compression.rans.rans4x8;

import htsjdk.samtools.cram.CRAMException;
import htsjdk.samtools.cram.compression.CompressionUtils;
import htsjdk.samtools.cram.compression.rans.RANSEncode;
import htsjdk.samtools.cram.compression.rans.RANSEncodingSymbol;
import htsjdk.samtools.cram.compression.rans.RANSParams;
import htsjdk.samtools.cram.compression.rans.Utils;
import htsjdk.samtools.cram.compression.rans.rans4x8.RANS4x8Params;
import htsjdk.utils.ValidationUtils;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class RANS4x8Encode
extends RANSEncode<RANS4x8Params> {
    private static final int MINIMUM_ORDER_1_SIZE = 4;
    private static final ByteBuffer EMPTY_BUFFER = CompressionUtils.allocateByteBuffer(0);

    @Override
    public ByteBuffer compress(ByteBuffer inBuffer, RANS4x8Params params) {
        if (inBuffer.remaining() == 0) {
            return EMPTY_BUFFER;
        }
        this.initializeRANSEncoder();
        if (inBuffer.remaining() < 4) {
            return this.compressOrder0Way4(inBuffer);
        }
        RANSParams.ORDER order = params.getOrder();
        switch (order) {
            case ZERO: {
                return this.compressOrder0Way4(inBuffer);
            }
            case ONE: {
                return this.compressOrder1Way4(inBuffer);
            }
        }
        throw new CRAMException("Unknown rANS order: " + String.valueOf((Object)params.getOrder()));
    }

    private ByteBuffer compressOrder0Way4(ByteBuffer inBuffer) {
        int inputSize = inBuffer.remaining();
        ByteBuffer outBuffer = CompressionUtils.allocateOutputBuffer(inputSize);
        outBuffer.position(9);
        int[] normalizedFreq = RANS4x8Encode.calcFrequenciesOrder0(inBuffer);
        this.buildSymsOrder0(normalizedFreq);
        ByteBuffer cp = CompressionUtils.slice(outBuffer);
        int frequencyTableSize = RANS4x8Encode.writeFrequenciesOrder0(cp, normalizedFreq);
        inBuffer.rewind();
        RANSEncodingSymbol[] syms = this.getEncodingSymbols()[0];
        int in_size = inBuffer.remaining();
        ByteBuffer ptr = CompressionUtils.slice(cp);
        long rans0 = 0x800000L;
        long rans1 = 0x800000L;
        long rans2 = 0x800000L;
        long rans3 = 0x800000L;
        int i = in_size & 3;
        switch (i) {
            case 3: {
                rans2 = syms[0xFF & inBuffer.get(in_size - (i - 2))].putSymbol4x8(rans2, ptr);
            }
            case 2: {
                rans1 = syms[0xFF & inBuffer.get(in_size - (i - 1))].putSymbol4x8(rans1, ptr);
            }
            case 1: {
                rans0 = syms[0xFF & inBuffer.get(in_size - i)].putSymbol4x8(rans0, ptr);
            }
        }
        for (i = in_size & 0xFFFFFFFC; i > 0; i -= 4) {
            byte c3 = inBuffer.get(i - 1);
            byte c2 = inBuffer.get(i - 2);
            byte c1 = inBuffer.get(i - 3);
            byte c0 = inBuffer.get(i - 4);
            rans3 = syms[0xFF & c3].putSymbol4x8(rans3, ptr);
            rans2 = syms[0xFF & c2].putSymbol4x8(rans2, ptr);
            rans1 = syms[0xFF & c1].putSymbol4x8(rans1, ptr);
            rans0 = syms[0xFF & c0].putSymbol4x8(rans0, ptr);
        }
        ptr.order(ByteOrder.BIG_ENDIAN);
        ptr.putInt((int)rans3);
        ptr.putInt((int)rans2);
        ptr.putInt((int)rans1);
        ptr.putInt((int)rans0);
        ptr.flip();
        int cdata_size = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        RANS4x8Encode.writeCompressionPrefix(RANSParams.ORDER.ZERO, outBuffer, inputSize, frequencyTableSize, cdata_size);
        return outBuffer;
    }

    private ByteBuffer compressOrder1Way4(ByteBuffer inBuffer) {
        int inSize = inBuffer.remaining();
        ByteBuffer outBuffer = CompressionUtils.allocateOutputBuffer(inSize);
        outBuffer.position(9);
        int[][] normalizedFreq = RANS4x8Encode.calcFrequenciesOrder1(inBuffer);
        this.buildSymsOrder1(normalizedFreq);
        ByteBuffer cp = CompressionUtils.slice(outBuffer);
        int frequencyTableSize = RANS4x8Encode.writeFrequenciesOrder1(cp, normalizedFreq);
        inBuffer.rewind();
        int in_size = inBuffer.remaining();
        long rans0 = 0x800000L;
        long rans1 = 0x800000L;
        long rans2 = 0x800000L;
        long rans3 = 0x800000L;
        int isz4 = in_size >> 2;
        int i0 = isz4 - 2;
        int i1 = 2 * isz4 - 2;
        int i2 = 3 * isz4 - 2;
        int i3 = 4 * isz4 - 2;
        byte l0 = 0;
        if (i0 + 1 >= 0) {
            l0 = inBuffer.get(i0 + 1);
        }
        byte l1 = 0;
        if (i1 + 1 >= 0) {
            l1 = inBuffer.get(i1 + 1);
        }
        byte l2 = 0;
        if (i2 + 1 >= 0) {
            l2 = inBuffer.get(i2 + 1);
        }
        byte l3 = inBuffer.get(in_size - 1);
        ByteBuffer ptr = CompressionUtils.slice(cp);
        RANSEncodingSymbol[][] syms = this.getEncodingSymbols();
        for (i3 = in_size - 2; i3 > 4 * isz4 - 2 && i3 >= 0; --i3) {
            byte c3 = inBuffer.get(i3);
            rans3 = syms[0xFF & c3][0xFF & l3].putSymbol4x8(rans3, ptr);
            l3 = c3;
        }
        while (i0 >= 0) {
            byte c0 = inBuffer.get(i0);
            byte c1 = inBuffer.get(i1);
            byte c2 = inBuffer.get(i2);
            byte c3 = inBuffer.get(i3);
            rans3 = syms[0xFF & c3][0xFF & l3].putSymbol4x8(rans3, ptr);
            rans2 = syms[0xFF & c2][0xFF & l2].putSymbol4x8(rans2, ptr);
            rans1 = syms[0xFF & c1][0xFF & l1].putSymbol4x8(rans1, ptr);
            rans0 = syms[0xFF & c0][0xFF & l0].putSymbol4x8(rans0, ptr);
            l0 = c0;
            l1 = c1;
            l2 = c2;
            l3 = c3;
            --i0;
            --i1;
            --i2;
            --i3;
        }
        rans3 = syms[0][0xFF & l3].putSymbol4x8(rans3, ptr);
        rans2 = syms[0][0xFF & l2].putSymbol4x8(rans2, ptr);
        rans1 = syms[0][0xFF & l1].putSymbol4x8(rans1, ptr);
        rans0 = syms[0][0xFF & l0].putSymbol4x8(rans0, ptr);
        ptr.order(ByteOrder.BIG_ENDIAN);
        ptr.putInt((int)rans3);
        ptr.putInt((int)rans2);
        ptr.putInt((int)rans1);
        ptr.putInt((int)rans0);
        ptr.flip();
        int compressedBlobSize = ptr.limit();
        Utils.reverse(ptr);
        inBuffer.position(inBuffer.limit());
        RANS4x8Encode.writeCompressionPrefix(RANSParams.ORDER.ONE, outBuffer, inSize, frequencyTableSize, compressedBlobSize);
        return outBuffer;
    }

    private static void writeCompressionPrefix(RANSParams.ORDER order, ByteBuffer outBuffer, int inSize, int frequencyTableSize, int compressedBlobSize) {
        ValidationUtils.validateArg(order == RANSParams.ORDER.ONE || order == RANSParams.ORDER.ZERO, "unrecognized RANS order");
        outBuffer.limit(9 + frequencyTableSize + compressedBlobSize);
        outBuffer.put(0, (byte)(order != RANSParams.ORDER.ZERO ? 1 : 0));
        outBuffer.putInt(1, frequencyTableSize + compressedBlobSize);
        outBuffer.putInt(5, inSize);
        outBuffer.rewind();
    }

    private static int[] calcFrequenciesOrder0(ByteBuffer inBuffer) {
        int T = inBuffer.remaining();
        int[] F = new int[256];
        for (int i = 0; i < T; ++i) {
            int n = 0xFF & inBuffer.get();
            F[n] = F[n] + 1;
        }
        int m = 0;
        int M = 0;
        for (int j = 0; j < 256; ++j) {
            if (m >= F[j]) continue;
            m = F[j];
            M = j;
        }
        long tr = 0x80000000000L / (long)T + (long)(0x40000000 / T);
        int fsum = 0;
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            F[j] = (int)((long)F[j] * tr >> 31);
            if (F[j] == 0) {
                F[j] = 1;
            }
            fsum += F[j];
        }
        if (fsum < 4096) {
            int n = M;
            F[n] = F[n] + (4096 - fsum);
        } else {
            int n = M;
            F[n] = F[n] - (fsum - 4096);
        }
        return F;
    }

    private static int[][] calcFrequenciesOrder1(ByteBuffer in) {
        int i;
        int in_size = in.remaining();
        int[][] F = new int[256][256];
        int[] T = new int[256];
        int last_i = 0;
        for (i = 0; i < in_size; ++i) {
            int c = 0xFF & in.get();
            int[] nArray = F[last_i];
            int n = c;
            nArray[n] = nArray[n] + 1;
            int n2 = last_i;
            T[n2] = T[n2] + 1;
            last_i = c;
        }
        int[] nArray = F[0];
        int n = 0xFF & in.get(in_size >> 2);
        nArray[n] = nArray[n] + 1;
        int[] nArray2 = F[0];
        int n3 = 0xFF & in.get(2 * (in_size >> 2));
        nArray2[n3] = nArray2[n3] + 1;
        int[] nArray3 = F[0];
        int n4 = 0xFF & in.get(3 * (in_size >> 2));
        nArray3[n4] = nArray3[n4] + 1;
        T[0] = T[0] + 3;
        for (i = 0; i < 256; ++i) {
            if (T[i] == 0) continue;
            double p = 4096.0 / (double)T[i];
            int t2 = 0;
            int m = 0;
            int M = 0;
            for (int j = 0; j < 256; ++j) {
                if (F[i][j] == 0) continue;
                if (m < F[i][j]) {
                    m = F[i][j];
                    M = j;
                }
                int[] nArray4 = F[i];
                int n5 = j;
                nArray4[n5] = (int)((double)nArray4[n5] * p);
                if (nArray4[n5] == 0) {
                    F[i][j] = 1;
                }
                t2 += F[i][j];
            }
            if (t2 < 4096) {
                int[] nArray5 = F[i];
                int n6 = M;
                nArray5[n6] = nArray5[n6] + (4096 - t2);
                continue;
            }
            int[] nArray6 = F[i];
            int n7 = M;
            nArray6[n7] = nArray6[n7] - (t2 - 4096);
        }
        return F;
    }

    private static int writeFrequenciesOrder0(ByteBuffer cp, int[] F) {
        int start = cp.position();
        int rle = 0;
        for (int j = 0; j < 256; ++j) {
            if (F[j] == 0) continue;
            if (rle != 0) {
                --rle;
            } else {
                cp.put((byte)j);
                if (rle == 0 && j != 0 && F[j - 1] != 0) {
                    for (rle = j + 1; rle < 256 && F[rle] != 0; ++rle) {
                    }
                    cp.put((byte)(rle -= j + 1));
                }
            }
            if (F[j] < 128) {
                cp.put((byte)F[j]);
                continue;
            }
            cp.put((byte)(0x80 | F[j] >> 8));
            cp.put((byte)(F[j] & 0xFF));
        }
        cp.put((byte)0);
        return cp.position() - start;
    }

    private static int writeFrequenciesOrder1(ByteBuffer cp, int[][] F) {
        int start = cp.position();
        int[] T = new int[256];
        for (int i = 0; i < 256; ++i) {
            for (int j = 0; j < 256; ++j) {
                int n = i;
                T[n] = T[n] + F[i][j];
            }
        }
        int rle_i = 0;
        for (int i = 0; i < 256; ++i) {
            if (T[i] == 0) continue;
            if (rle_i != 0) {
                --rle_i;
            } else {
                cp.put((byte)i);
                if (i != 0 && T[i - 1] != 0) {
                    for (rle_i = i + 1; rle_i < 256 && T[rle_i] != 0; ++rle_i) {
                    }
                    cp.put((byte)(rle_i -= i + 1));
                }
            }
            int[] F_i_ = F[i];
            int rle_j = 0;
            for (int j = 0; j < 256; ++j) {
                if (F_i_[j] == 0) continue;
                if (rle_j != 0) {
                    --rle_j;
                } else {
                    cp.put((byte)j);
                    if (rle_j == 0 && j != 0 && F_i_[j - 1] != 0) {
                        for (rle_j = j + 1; rle_j < 256 && F_i_[rle_j] != 0; ++rle_j) {
                        }
                        cp.put((byte)(rle_j -= j + 1));
                    }
                }
                if (F_i_[j] < 128) {
                    cp.put((byte)F_i_[j]);
                    continue;
                }
                cp.put((byte)(0x80 | F_i_[j] >> 8));
                cp.put((byte)(F_i_[j] & 0xFF));
            }
            cp.put((byte)0);
        }
        cp.put((byte)0);
        return cp.position() - start;
    }
}

