/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.stream;

import htsjdk.samtools.seekablestream.SeekableStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;

public class IGVSeekableFileStream
extends SeekableStream {
    File file;
    long position;

    public IGVSeekableFileStream(File file) throws FileNotFoundException {
        this.file = file;
    }

    public long length() {
        return this.file.length();
    }

    public boolean eof() throws IOException {
        return this.position == this.file.length();
    }

    public void seek(long position) throws IOException {
        this.position = position;
    }

    public long position() throws IOException {
        return this.position;
    }

    public long skip(long n) throws IOException {
        long initPos = this.position;
        this.position = Math.min(this.file.length(), this.position + n);
        return this.position - initPos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] buffer, int offset, int length) throws IOException {
        if (length < 0) {
            throw new IndexOutOfBoundsException();
        }
        try (RandomAccessFile fis = null;){
            int n;
            int count;
            fis = new RandomAccessFile(this.file, "r");
            fis.seek(this.position);
            for (n = 0; n < length; n += count) {
                count = fis.read(buffer, offset + n, length - n);
                if (count >= 0) continue;
                if (n > 0) {
                    int n2 = n;
                    return n2;
                }
                int n3 = count;
                return n3;
            }
            int n4 = n;
            return n4;
        }
    }

    public int read() throws IOException {
        fis.seek(this.position);
        try (RandomAccessFile fis = null;){
            int n = fis.read();
            return n;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(byte[] b) throws IOException {
        fis.seek(this.position);
        try (RandomAccessFile fis = null;){
            int n = fis.read(b);
            return n;
        }
    }

    public String getSource() {
        return this.file.getAbsolutePath();
    }

    public void close() throws IOException {
    }
}

