/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.extview;

import java.io.IOException;
import java.util.HashMap;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.Alignment;
import org.igv.ui.util.MessageUtils;
import org.igv.util.HttpUtils;

public class ExtendViewClient {
    static int sleepTime = 15000;

    public static void postExtendView(String fName, int start, int end, String r_chr, int r_start, int r_end) {
        MessageUtils.showMessage("fName :" + fName + " start:" + start + " end:" + end + "<br>chr :" + r_chr + " start:" + r_start + " end:" + r_end);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", fName);
        params.put("start", String.valueOf(start));
        params.put("end", String.valueOf(end));
        params.put("chr", r_chr);
        params.put("r_start", String.valueOf(r_start));
        params.put("r_end", String.valueOf(r_end));
        String $url = PreferencesManager.getPreferences().get("EXTVIEW_URL");
        String urlString = $url + "/FeatureRange/";
        try {
            String result = HttpUtils.getInstance().doPost(HttpUtils.createURL(urlString), params);
            MessageUtils.showMessage("results:" + result);
        }
        catch (IOException e1) {
            MessageUtils.showErrorMessage("Error in opening extend view: FeatureRange ", e1);
        }
    }

    public static void postExtendView(Alignment aln) {
        String chr = aln.getChr();
        int start = aln.getAlignmentStart();
        int end = aln.getAlignmentEnd();
        Genome genome = GenomeManager.getInstance().getCurrentGenome();
        byte[] seqBytes = genome.getSequence(chr, start -= 10000, end += 10000);
        String userSeq = new String(seqBytes);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("chr", chr);
        params.put("start", String.valueOf(start));
        params.put("end", String.valueOf(end));
        params.put("strand", String.valueOf((Object)aln.getReadStrand()));
        params.put("read_name", aln.getReadName());
        params.put("read_seq", aln.getReadSequence());
        params.put("ref_seq", userSeq);
        String $url = PreferencesManager.getPreferences().get("EXTVIEW_URL");
        String urlString = $url + "/ExamineReadAlignment/";
        try {
            String string = HttpUtils.getInstance().doPost(HttpUtils.createURL(urlString), params);
        }
        catch (IOException e1) {
            MessageUtils.showErrorMessage("Error in opening extend view: ExamineReadAlignment", e1);
        }
    }
}

