/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util.collections;

import java.util.Random;
import org.igv.util.collections.DoubleArrayList;

public class DownsampledDoubleArrayList {
    private static final Random RAND = new Random(System.currentTimeMillis());
    int maxSize;
    DoubleArrayList data;
    int downsampledCount = 0;

    public DownsampledDoubleArrayList(int initialSize, int maxSize) {
        this.maxSize = maxSize;
        this.data = new DoubleArrayList(initialSize);
    }

    public void add(double d) {
        if (this.data.size() < this.maxSize) {
            this.data.add(d);
        } else {
            double samplingProb = (double)this.maxSize / (double)(this.maxSize + this.downsampledCount + 1);
            if (RAND.nextDouble() < samplingProb) {
                int idx = (int)(RAND.nextDouble() * (double)(this.data.size() - 1));
                this.data.set(idx, d);
            }
            ++this.downsampledCount;
        }
    }

    public double get(int idx) {
        return this.data.get(idx);
    }

    public int size() {
        return this.data.size();
    }

    public boolean isSampled() {
        return this.downsampledCount > 0;
    }

    public int getDownsampledCount() {
        return this.downsampledCount;
    }

    public double[] toArray() {
        return this.data.toArray();
    }
}

