/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import biz.source_code.base64Coder.Base64Coder;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.igv.Globals;

public class ProxiedHttpsConnection
extends HttpURLConnection {
    private final String proxyHost;
    private final int proxyPort;
    private static final byte[] NEWLINE = "\r\n".getBytes();
    private Socket socket;
    private FilteredInputStream inputStream;
    private final Map<String, List<String>> headers = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, List<String>> sendheaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, List<String>> proxyheaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private final Map<String, List<String>> proxyreturnheaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
    private int statusCode;
    private String statusLine;

    public ProxiedHttpsConnection(URL url, String proxyHost, int proxyPort, String username, String password) throws IOException {
        super(url);
        this.socket = new Socket();
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        char[] encoded = Base64Coder.encode((username + ":" + password).getBytes());
        this.proxyheaders.put("Proxy-Authorization", new ArrayList<String>(Arrays.asList("Basic " + String.valueOf((Object)encoded))));
    }

    @Override
    public int getResponseCode() throws IOException {
        this.connect();
        this.inputStream.parseHeaders();
        return this.statusCode;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        this.connect();
        return this.inputStream;
    }

    @Override
    public void setRequestMethod(String method) throws ProtocolException {
        this.method = method;
    }

    @Override
    public void setRequestProperty(String key, String value) {
        this.sendheaders.put(key, new ArrayList<String>(Arrays.asList(value)));
    }

    @Override
    public void addRequestProperty(String key, String value) {
        this.sendheaders.computeIfAbsent(key, l -> new ArrayList()).add(value);
    }

    @Override
    public Map<String, List<String>> getHeaderFields() {
        return this.headers;
    }

    @Override
    public void connect() throws IOException {
        String replyStr;
        byte[] bytes;
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.socket.setSoTimeout(this.getReadTimeout());
        this.socket.connect(new InetSocketAddress(this.proxyHost, this.proxyPort), this.getConnectTimeout());
        StringBuilder msg = new StringBuilder();
        msg.append("CONNECT ");
        msg.append(this.url.getHost());
        msg.append(':');
        msg.append(this.url.getPort() == -1 ? 443 : this.url.getPort());
        msg.append(" HTTP/1.0\r\n");
        for (Map.Entry<String, List<String>> header : this.proxyheaders.entrySet()) {
            for (String l2 : header.getValue()) {
                msg.append(header.getKey()).append(": ").append(l2);
                msg.append("\r\n");
            }
        }
        msg.append("Connection: close\r\n");
        msg.append("\r\n");
        try {
            bytes = msg.toString().getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            bytes = msg.toString().getBytes();
        }
        this.socket.getOutputStream().write(bytes);
        this.socket.getOutputStream().flush();
        byte[] reply = new byte[200];
        byte[] header = new byte[200];
        int replyLen = 0;
        int headerLen = 0;
        int newlinesSeen = 0;
        boolean headerDone = false;
        InputStream in = this.socket.getInputStream();
        while (newlinesSeen < 2) {
            int i = in.read();
            if (i < 0) {
                throw new IOException("Unexpected EOF from remote server");
            }
            if (i == 10) {
                String h;
                Object split;
                if (newlinesSeen != 0 && ((String[])(split = (h = new String(header, 0, headerLen)).split(": "))).length != 1) {
                    this.proxyreturnheaders.computeIfAbsent(split[0], l -> new ArrayList()).add(split[1]);
                }
                headerDone = true;
                ++newlinesSeen;
                headerLen = 0;
                continue;
            }
            if (i == 13) continue;
            newlinesSeen = 0;
            if (!headerDone && replyLen < reply.length) {
                reply[replyLen++] = (byte)i;
                continue;
            }
            if (headerLen >= reply.length) continue;
            header[headerLen++] = (byte)i;
        }
        try {
            replyStr = new String(reply, 0, replyLen, "ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            replyStr = new String(reply, 0, replyLen);
        }
        if (!replyStr.startsWith("HTTP/1.0 200") && !replyStr.startsWith("HTTP/1.1 200")) {
            throw new IOException("Unable to tunnel. Proxy returns \"" + replyStr + "\"");
        }
        SSLSocket s = (SSLSocket)((SSLSocketFactory)SSLSocketFactory.getDefault()).createSocket(this.socket, this.url.getHost(), this.url.getPort(), true);
        s.startHandshake();
        this.socket = s;
        msg.setLength(0);
        msg.append(this.method);
        msg.append(" ");
        msg.append(this.url.toExternalForm());
        msg.append(" HTTP/1.0\r\n");
        for (Map.Entry entry : this.sendheaders.entrySet()) {
            for (String l3 : (List)entry.getValue()) {
                msg.append((String)entry.getKey()).append(": ").append(l3);
                msg.append("\r\n");
            }
        }
        if (this.method.equals("POST") || this.method.equals("PUT")) {
            msg.append("Transfer-Encoding: Chunked\r\n");
        }
        msg.append("Host: ").append(this.url.getHost()).append("\r\n");
        msg.append("Connection: close\r\n");
        msg.append("\r\n");
        try {
            bytes = msg.toString().getBytes("ASCII7");
        }
        catch (UnsupportedEncodingException ignored) {
            bytes = msg.toString().getBytes();
        }
        this.socket.getOutputStream().write(bytes);
        this.socket.getOutputStream().flush();
        this.inputStream = new FilteredInputStream(this.socket.getInputStream());
    }

    @Override
    public void disconnect() {
        try {
            this.socket.close();
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Override
    public boolean usingProxy() {
        return true;
    }

    class FilteredInputStream
    extends InputStream {
        static final int MAX_HEADER_SIZE = 1000;
        InputStream wrappedStream;
        boolean headersRead = false;

        public FilteredInputStream(InputStream wrappedStream) {
            this.wrappedStream = wrappedStream;
        }

        @Override
        public int read() throws IOException {
            if (this.headersRead) {
                return this.wrappedStream.read();
            }
            this.parseHeaders();
            return this.wrappedStream.read();
        }

        @Override
        public void close() throws IOException {
            this.wrappedStream.close();
            super.close();
        }

        private void parseHeaders() throws IOException {
            if (this.headersRead) {
                return;
            }
            int newLineCount = 0;
            int headerLen = 0;
            byte[] header = new byte[1000];
            while (newLineCount < 2) {
                int i = this.wrappedStream.read();
                if (i == 10) {
                    String h = new String(header, 0, headerLen);
                    if (ProxiedHttpsConnection.this.statusLine == null) {
                        ProxiedHttpsConnection.this.statusLine = h;
                        String[] parts = Globals.whitespacePattern.split(h);
                        ProxiedHttpsConnection.this.statusCode = Integer.parseInt(parts[1]);
                    } else {
                        String[] split = h.split(": ");
                        if (split.length != 1) {
                            ProxiedHttpsConnection.this.headers.computeIfAbsent(split[0], l -> new ArrayList()).add(split[1]);
                        }
                    }
                    headerLen = 0;
                    ++newLineCount;
                    continue;
                }
                if (i == 13) continue;
                newLineCount = 0;
                if (headerLen >= 1000) continue;
                header[headerLen++] = (byte)i;
            }
            this.headersRead = true;
        }
    }
}

