/*
 * Decompiled with CFR 0.152.
 */
package org.igv.util;

import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.igv.Globals;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;
import org.igv.ui.WaitCursorManager;
import org.igv.ui.util.MessageUtils;

public class LongRunningTask
implements Callable<Void> {
    private static final Logger log = LogManager.getLogger(LongRunningTask.class);
    private static final ExecutorService threadExecutor = Executors.newFixedThreadPool(5);
    Runnable runnable;

    public static Executor getThreadExecutor() {
        return threadExecutor;
    }

    public static Future<Void> submit(Runnable runnable) {
        if (Globals.isBatch()) {
            runnable.run();
            return null;
        }
        return threadExecutor.submit(new LongRunningTask(runnable));
    }

    private LongRunningTask(Runnable runnable) {
        this.runnable = runnable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Void call() {
        WaitCursorManager.CursorToken token = WaitCursorManager.showWaitCursor();
        try {
            this.runnable.run();
        }
        catch (Throwable e) {
            MessageUtils.showMessage("<html>Unexpected error: " + e.getMessage() + ".<br>See igv.log for more details");
            log.error("Exception running task", e);
        }
        finally {
            WaitCursorManager.removeWaitCursor(token);
            IGV iGV = IGV.getInstance();
            synchronized (iGV) {
                IGV.getInstance().notifyAll();
            }
        }
        return null;
    }
}

