/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.util;

import java.awt.event.MouseEvent;
import javax.swing.event.MouseInputAdapter;
import org.igv.ui.UIConstants;
import org.igv.ui.util.IGVMouseEvent;

public class IGVMouseInputAdapter
extends MouseInputAdapter {
    MouseEvent mouseDown;
    long lastClickTime = 0L;
    int clickCount = 1;

    @Override
    public void mousePressed(MouseEvent e) {
        if (!e.isPopupTrigger()) {
            this.mouseDown = e;
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (!e.isPopupTrigger() && this.mouseDown != null && this.distance(this.mouseDown, e) < 5.0) {
            long time = System.currentTimeMillis();
            this.clickCount = time - this.lastClickTime < (long)UIConstants.getDoubleClickInterval() ? ++this.clickCount : 1;
            this.lastClickTime = time;
            this.igvMouseClicked(new IGVMouseEvent(e, this.clickCount));
        }
    }

    public void igvMouseClicked(MouseEvent e) {
    }

    private double distance(MouseEvent e1, MouseEvent e2) {
        double dx = e1.getX() - e2.getX();
        double dy = e1.getY() - e2.getY();
        return Math.sqrt(dx * dx + dy * dy);
    }
}

