/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.panel;

import htsjdk.samtools.util.Locatable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.igv.event.GenomeChangeEvent;
import org.igv.event.IGVEvent;
import org.igv.event.IGVEventBus;
import org.igv.event.IGVEventObserver;
import org.igv.feature.Locus;
import org.igv.feature.Range;
import org.igv.feature.genome.ChromosomeNameComparator;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.lists.GeneList;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.SortOption;
import org.igv.track.RegionScoreType;
import org.igv.track.Track;
import org.igv.ui.IGV;
import org.igv.ui.action.SearchCommand;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.util.MessageUtils;

public class FrameManager
implements IGVEventObserver {
    public static final Comparator<String> FRAME_COMPARATOR = (n0, n1) -> {
        ReferenceFrame f0 = FrameManager.getFrame(n0);
        ReferenceFrame f1 = FrameManager.getFrame(n1);
        String chr0 = f0 == null ? "" : f0.getChrName();
        String chr1 = f1 == null ? "" : f1.getChrName();
        int s0 = f0 == null ? 0 : f0.getCurrentRange().getStart();
        int s1 = f1 == null ? 0 : f1.getCurrentRange().getStart();
        int chrComp = ChromosomeNameComparator.get().compare(chr0, chr1);
        if (chrComp != 0) {
            return chrComp;
        }
        return s0 - s1;
    };
    private static List<ReferenceFrame> frames = new ArrayList<ReferenceFrame>();
    private static ReferenceFrame defaultFrame;
    public static final String DEFAULT_FRAME_NAME = "genome";

    public static String getCurrentLocusString() {
        if (FrameManager.isGeneListMode()) {
            Object name = frames.get(0).getName();
            for (int i = 1; i < frames.size(); ++i) {
                name = (String)name + " | " + frames.get(i).getName();
            }
            return name;
        }
        return defaultFrame.getFormattedLocusString();
    }

    public static synchronized ReferenceFrame getDefaultFrame() {
        if (defaultFrame == null) {
            defaultFrame = new ReferenceFrame(DEFAULT_FRAME_NAME);
        }
        return defaultFrame;
    }

    public static ReferenceFrame getFirstFrame() {
        return FrameManager.isGeneListMode() ? frames.get(0) : defaultFrame;
    }

    public static List<ReferenceFrame> getFrames() {
        return frames;
    }

    public static ReferenceFrame getFrame(String frameName) {
        for (ReferenceFrame frame : frames) {
            if (!frame.getName().equals(frameName)) continue;
            return frame;
        }
        return null;
    }

    public static void setFrames(List<ReferenceFrame> f) {
        frames = f;
        IGVEventBus.getInstance().post(new ChangeEvent(frames));
    }

    public static boolean isGeneListMode() {
        return frames.size() > 1;
    }

    public static void setToDefaultFrame(String searchString) {
        Locus locus;
        frames.clear();
        if (searchString != null && (locus = FrameManager.getLocus(searchString, 0)) != null) {
            FrameManager.getDefaultFrame().jumpTo(locus);
        }
        frames.add(FrameManager.getDefaultFrame());
        FrameManager.getDefaultFrame().recordHistory();
        IGVEventBus.getInstance().post(new ChangeEvent(frames));
    }

    private static boolean addNewFrame(String searchString) {
        boolean locusAdded = false;
        Locus locus = FrameManager.getLocus(searchString);
        if (locus != null) {
            ReferenceFrame referenceFrame = new ReferenceFrame(searchString);
            referenceFrame.jumpTo(locus);
            locusAdded = frames.add(referenceFrame);
        }
        return locusAdded;
    }

    public static void resetFrames(GeneList gl) {
        frames.clear();
        if (gl == null) {
            frames.add(FrameManager.getDefaultFrame());
        } else {
            ArrayList<String> lociNotFound = new ArrayList<String>();
            List<String> loci = gl.getLoci();
            if (loci.size() == 1) {
                Locus locus = FrameManager.getLocus(loci.get(0));
                if (locus == null) {
                    lociNotFound.add(loci.get(0));
                } else {
                    IGV.getInstance().getSession().setCurrentGeneList(null);
                    FrameManager.getDefaultFrame().jumpTo(locus.getChr(), locus.getStart(), locus.getEnd());
                    frames.add(FrameManager.getDefaultFrame());
                }
            } else {
                for (String searchString : gl.getLoci()) {
                    if (FrameManager.addNewFrame(searchString)) continue;
                    lociNotFound.add(searchString);
                }
            }
            if (lociNotFound.size() > 1) {
                StringBuffer message = new StringBuffer();
                message.append("<html>The following loci could not be found in the currently loaded annotation sets: <br>");
                for (String s : lociNotFound) {
                    message.append(s + " ");
                }
                MessageUtils.showMessage(message.toString());
            }
        }
        IGVEventBus.getInstance().post(new ChangeEvent(frames));
    }

    public static double getMinimumScale() {
        double minScale = Double.MAX_VALUE;
        for (ReferenceFrame frame : frames) {
            minScale = Math.min(minScale, frame.getScale());
        }
        return minScale;
    }

    public static Locus getLocus(String searchString) {
        int flankingRegion = PreferencesManager.getPreferences().getAsInt("FLANKING_REGION");
        return FrameManager.getLocus(searchString, flankingRegion);
    }

    public static Locus getLocus(String searchString, int flankingRegion) {
        SearchCommand cmd = new SearchCommand(FrameManager.getDefaultFrame(), searchString);
        List<SearchCommand.SearchResult> results = cmd.runSearch(searchString);
        Locus locus = null;
        for (SearchCommand.SearchResult result : results) {
            int start;
            if (result.getType() == SearchCommand.ResultType.ERROR) continue;
            int delta = 0;
            if (result.getType() != SearchCommand.ResultType.LOCUS) {
                delta = flankingRegion < 0 ? -flankingRegion * (result.getEnd() - result.getStart()) / 100 : flankingRegion;
            }
            if ((start = result.getStart() - delta) < 0 && result.getStart() >= -1) {
                start = 0;
            }
            locus = new Locus(result.getChr(), start, result.getEnd() + delta);
            break;
        }
        return locus;
    }

    public static void removeFrame(ReferenceFrame frame) {
        frames.remove(frame);
    }

    public static void sortFrames(Track t) {
        frames.sort(Comparator.comparingDouble(f -> t.getRegionScore(f.getChromosome().getName(), (int)f.getOrigin(), (int)f.getEnd(), f.getZoom(), RegionScoreType.SCORE, f.getName())).reversed());
    }

    public static void incrementZoom(int zoom) {
        if (FrameManager.isGeneListMode()) {
            for (ReferenceFrame frame : FrameManager.getFrames()) {
                frame.doZoomIncrement(zoom);
            }
        } else {
            FrameManager.getDefaultFrame().doZoomIncrement(zoom);
        }
    }

    public static void addFrames(List<String> newLociStrings) {
        if (newLociStrings.size() != 2) {
            throw new RuntimeException("Unexpected list size: " + newLociStrings.size());
        }
        List newLoci = newLociStrings.stream().map(s -> {
            Locus locus = Locus.fromString(s);
            locus.chr = GenomeManager.getInstance().getCurrentGenome().getCanonicalChrName(locus.chr);
            return locus;
        }).collect(Collectors.toList());
        if (((Locus)newLoci.get(0)).overlaps((Range)newLoci.get(1))) {
            ((Locus)newLoci.get((int)0)).start = Math.min(((Locus)newLoci.get((int)0)).start, ((Locus)newLoci.get((int)1)).start);
            ((Locus)newLoci.get((int)0)).end = Math.max(((Locus)newLoci.get((int)0)).end, ((Locus)newLoci.get((int)1)).end);
            newLoci.remove(1);
        }
        List<ReferenceFrame> currentFrames = FrameManager.isGeneListMode() ? frames : (FrameManager.defaultFrame.chrName.equals("All") ? Arrays.asList(new ReferenceFrame[0]) : Arrays.asList(defaultFrame));
        HashSet<ReferenceFrame> usedFrames = new HashSet<ReferenceFrame>();
        ArrayList<String> loci = new ArrayList<String>();
        for (Locus locus : newLoci) {
            boolean found = false;
            for (ReferenceFrame ref : currentFrames) {
                if (locus == null || !ref.getChrName().equals(locus.chr) || !ref.getCurrentRange().overlaps(locus)) continue;
                Range union = ref.getCurrentRange().union(locus);
                loci.add(Locus.getFormattedLocusString(union.getChr(), union.getStart(), union.getEnd()));
                found = true;
                usedFrames.add(ref);
                break;
            }
            if (found) continue;
            loci.add(Locus.getFormattedLocusString(locus.getChr(), locus.getStart(), locus.getEnd()));
        }
        for (ReferenceFrame ref : currentFrames) {
            if (usedFrames.contains(ref)) continue;
            loci.add(ref.getFormattedLocusString());
        }
        GeneList geneList = new GeneList("Current frames", loci);
        geneList.sort(FRAME_COMPARATOR);
        IGV.getInstance().getSession().setCurrentGeneList(geneList);
        IGV.getInstance().resetFrames();
    }

    public static void addNewLociToFrames(ReferenceFrame frame, List<? extends Locatable> toIncludeInSplit) {
        Stream<String> newLoci = toIncludeInSplit.stream().map(locatable -> FrameManager.getLocusStringScaledToFrame(frame, locatable));
        Stream<String> existingFrames = FrameManager.getFrames().stream().map(ref -> {
            String name = ref.getName();
            return Locus.fromString(name) != null ? name : ref.getFormattedLocusString();
        });
        Comparator<String> comparator = Comparator.comparing(Locus::fromString, SortOption.POSITION_COMPARATOR);
        List<String> loci = Stream.concat(newLoci, existingFrames).sorted(comparator).distinct().collect(Collectors.toList());
        String listName = String.join((CharSequence)"   ", loci);
        GeneList geneList = new GeneList(listName, loci);
        geneList.sort(comparator);
        IGV.getInstance().getSession().setCurrentGeneList(geneList);
        IGV.getInstance().resetFrames();
    }

    private static String getLocusStringScaledToFrame(ReferenceFrame frame, Locatable alignment) {
        int adjustedMateStart = alignment.getStart() - 1;
        Range range = frame.getCurrentRange();
        int length = range.getLength();
        int start = Math.max(0, adjustedMateStart - length / 2);
        int end = start + length;
        return alignment.getContig() + ":" + start + "-" + end;
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        if (event instanceof GenomeChangeEvent) {
            GenomeChangeEvent e = (GenomeChangeEvent)event;
            Genome newGenome = e.genome();
            boolean force = true;
            FrameManager.getDefaultFrame().setChromosomeName(newGenome.getHomeChromosome(), force);
        }
    }

    static {
        frames.add(FrameManager.getDefaultFrame());
    }

    public record ChangeEvent(List<ReferenceFrame> frames) implements IGVEvent
    {
    }
}

