/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.genome;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.RowFilter;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.NumberFormatter;
import org.igv.DirectoryManager;
import org.igv.Globals;
import org.igv.event.GenomeResetEvent;
import org.igv.event.IGVEventBus;
import org.igv.feature.genome.GenomeDownloadUtils;
import org.igv.feature.genome.GenomeManager;
import org.igv.feature.genome.load.GenomeConfig;
import org.igv.feature.genome.load.HubGenomeLoader;
import org.igv.feature.genome.load.JsonGenomeLoader;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ucsc.hub.Hub;
import org.igv.ucsc.hub.HubParser;
import org.igv.ui.IGVDialog;
import org.igv.ui.genome.GenomeListItem;
import org.igv.ui.genome.GenomeTableModel;
import org.igv.ui.util.MessageUtils;
import org.igv.util.LongRunningTask;

public class GenomeSelectionDialog
extends IGVDialog {
    private static Logger log = LogManager.getLogger(GenomeSelectionDialog.class);
    private static NumberFormatter numberFormatter = new NumberFormatter();
    private JTable table;
    private JTextField filterTextField;
    JPanel downloadSequencePanel;
    ButtonGroup downloadSequenceGroup;
    private JRadioButton downloadSequenceRB;
    private JRadioButton remoteSequenceRB;
    JPanel downloadAnnotationsPanel;
    ButtonGroup downloadAnnotationsGroup;
    private JRadioButton downloadAnnotationsRB;
    private JRadioButton remoteAnnotationsRB;
    private List<GenomeListItem> allListItems;
    private DefaultListModel genomeListModel;
    private GenomeTableModel model;
    private boolean canceled;

    public GenomeSelectionDialog(Frame owner, GenomeTableModel model) {
        super(owner);
        this.model = model;
        this.setModal(true);
        this.initComponents();
        this.init(model);
    }

    private void init(GenomeTableModel model) {
        this.setModal(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
        this.table.setModel(model);
        this.table.setRowSorter(model.getSorter());
        this.filterTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void changedUpdate(DocumentEvent e) {
                GenomeSelectionDialog.this.updateFilter();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                GenomeSelectionDialog.this.updateFilter();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                GenomeSelectionDialog.this.updateFilter();
            }
        });
    }

    private void updateFilter() {
        RegexFilter rf = null;
        try {
            rf = new RegexFilter(this.filterTextField.getText());
        }
        catch (PatternSyntaxException e) {
            return;
        }
        this.model.getSorter().setRowFilter(rf);
    }

    private void cancelButtonActionPerformed(ActionEvent e) {
        this.canceled = true;
        this.setVisible(false);
        IGVEventBus.getInstance().post(new GenomeResetEvent());
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    private GenomeListItem getSelectedRecord() {
        int idx = this.table.getSelectedRow();
        if (idx < 0) {
            return null;
        }
        int modelIndex = this.table.convertRowIndexToModel(idx);
        return this.model.getRecords().get(modelIndex);
    }

    private void initComponents() {
        this.setModal(true);
        this.setTitle("Genome Selector");
        JPanel outerPanel = new JPanel();
        outerPanel.setBorder(new EmptyBorder(20, 20, 20, 20));
        outerPanel.setLayout(new BorderLayout(0, 20));
        this.getContentPane().add(outerPanel);
        JPanel contentPanel = new JPanel();
        contentPanel.setLayout(new BoxLayout(contentPanel, 1));
        JLabel headerMessage = new JLabel();
        headerMessage.setText("Enter one or more search terms to filter genome list.");
        headerMessage.setRequestFocusEnabled(false);
        outerPanel.add((Component)headerMessage, "North");
        JPanel filterPanel = new JPanel();
        filterPanel.setLayout(new FlowLayout(0));
        String filterToolTip = "Enter multiple filter strings separated by spaces.";
        this.filterTextField = new JTextField();
        this.filterTextField.setMinimumSize(new Dimension(100, 25));
        this.filterTextField.setPreferredSize(new Dimension(900, 25));
        this.filterTextField.setToolTipText("Enter multiple filter strings separated by spaces.");
        JLabel filterLabel = new JLabel("Filter:");
        filterLabel.setLabelFor(this.filterTextField);
        filterLabel.setRequestFocusEnabled(false);
        filterPanel.add(filterLabel);
        filterLabel.setToolTipText("Enter multiple filter strings separated by spaces.");
        filterPanel.add(this.filterTextField);
        contentPanel.add(filterPanel);
        this.table = new JTable();
        Font headerFont = this.table.getTableHeader().getFont();
        Font boldHeaderFont = headerFont.deriveFont(1);
        this.table.getTableHeader().setFont(boldHeaderFont);
        JScrollPane scrollPane1 = new JScrollPane();
        scrollPane1.setViewportView(this.table);
        contentPanel.add(scrollPane1);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(2, 0));
        p1.setPreferredSize(new Dimension(500, 50));
        p1.setMinimumSize(new Dimension(500, 50));
        p1.setMaximumSize(new Dimension(1000, 50));
        this.downloadSequenceRB = new JRadioButton("Download sequence");
        this.remoteSequenceRB = new JRadioButton("Use remote sequence");
        this.remoteSequenceRB.setSelected(true);
        this.downloadSequenceGroup = new ButtonGroup();
        this.downloadSequenceGroup.add(this.downloadSequenceRB);
        this.downloadSequenceGroup.add(this.remoteSequenceRB);
        this.downloadSequencePanel = new JPanel();
        FlowLayout layout = new FlowLayout(0);
        this.downloadSequencePanel.setLayout(layout);
        this.downloadSequencePanel.add(this.downloadSequenceRB);
        this.downloadSequencePanel.add(this.remoteSequenceRB);
        p1.add(this.downloadSequencePanel);
        this.downloadAnnotationsRB = new JRadioButton("Download annotations");
        this.remoteAnnotationsRB = new JRadioButton("Use remote annotations");
        this.remoteAnnotationsRB.setSelected(true);
        this.downloadAnnotationsGroup = new ButtonGroup();
        this.downloadAnnotationsGroup.add(this.downloadAnnotationsRB);
        this.downloadAnnotationsGroup.add(this.remoteAnnotationsRB);
        this.downloadAnnotationsPanel = new JPanel();
        FlowLayout layout1 = new FlowLayout(0);
        this.downloadAnnotationsPanel.setLayout(layout1);
        this.downloadAnnotationsPanel.add(this.downloadAnnotationsRB);
        this.downloadAnnotationsPanel.add(this.remoteAnnotationsRB);
        p1.add(this.downloadAnnotationsPanel);
        contentPanel.add(p1);
        outerPanel.add((Component)contentPanel, "Center");
        JPanel buttonBar = new JPanel();
        buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        JButton okButton = new JButton();
        this.getRootPane().setDefaultButton(okButton);
        okButton.setText("Load");
        okButton.addActionListener(e -> this.loadButtonActionPerformed(e));
        buttonBar.add((Component)okButton, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        JButton cancelButton = new JButton();
        cancelButton.setText("Cancel");
        cancelButton.addActionListener(e -> this.cancelButtonActionPerformed(e));
        buttonBar.add((Component)cancelButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        outerPanel.add((Component)buttonBar, "South");
        if (this.model.getColumnCount() == 1) {
            this.setSize(500, 620);
        } else {
            this.setSize(1000, 620);
        }
        this.setLocationRelativeTo(this.getOwner());
    }

    private void loadButtonActionPerformed(ActionEvent evt) {
        this.canceled = false;
        try {
            GenomeListItem rec = this.getSelectedRecord();
            if (rec != null) {
                String url = rec.getAttributeValue("url");
                String id = rec.getAttributeValue("accession");
                Runnable showDialog = () -> {
                    try {
                        File localFile;
                        List<TrackConfig> selectedTracks;
                        GenomeConfig config;
                        if (url != null && url.endsWith(".json")) {
                            config = new JsonGenomeLoader(url).loadGenomeConfig();
                        } else {
                            String accession = rec.getAttributeValue("accession");
                            String hubURL = HubGenomeLoader.convertToHubURL(accession);
                            Hub hub = HubParser.loadHub(hubURL);
                            config = hub.getGenomeConfigs().get(0);
                            config.setHubs(Arrays.asList(hubURL));
                        }
                        config.setName(rec.getAttributeValue("common name"));
                        if (config.getHubs() != null && config.getHubs().size() > 0 && (selectedTracks = GenomeManager.selectAnnotationTracks(config, "Select default annotation tracks for this genome.  You can change these selections later using the 'Genomes > Select Default Annotations...' menu.")) != null && selectedTracks.size() > 0) {
                            config.setTracks(selectedTracks);
                        }
                        if ((localFile = GenomeDownloadUtils.downloadGenome(config, this.downloadSequenceRB.isSelected(), this.downloadAnnotationsRB.isSelected())) != null) {
                            GenomeManager.getInstance().loadGenome(localFile.getAbsolutePath());
                        } else {
                            GenomeManager.getInstance().loadGenome(url);
                        }
                        GenomeSelectionDialog.removeDotGenomeFile(id);
                    }
                    catch (IOException e) {
                        MessageUtils.showErrorMessage("Error loading genome " + url, e);
                        log.error("Error loading genome " + url, e);
                    }
                };
                if (SwingUtilities.isEventDispatchThread()) {
                    LongRunningTask.submit(showDialog);
                } else {
                    showDialog.run();
                }
            }
        }
        catch (Exception ex) {
            log.error(ex);
            MessageUtils.showMessage("Error loading genome: " + ex.getMessage());
        }
        this.setVisible(false);
    }

    private static void removeDotGenomeFile(String id) {
        try {
            File dotGenomeFile = new File(DirectoryManager.getGenomeCacheDirectory(), id + ".genome");
            if (dotGenomeFile.exists()) {
                dotGenomeFile.delete();
            }
        }
        catch (Exception e) {
            log.error("Error deleting .genome file", e);
        }
    }

    private class RegexFilter
    extends RowFilter {
        List<Matcher> matchers;

        RegexFilter(String text) {
            if (text == null) {
                throw new IllegalArgumentException("Pattern must be non-null");
            }
            this.matchers = Arrays.stream(Globals.whitespacePattern.split(text)).map(t -> {
                String value = t.trim();
                return Pattern.compile("(?i)" + value).matcher("");
            }).collect(Collectors.toList());
        }

        public boolean include(RowFilter.Entry value) {
            return this.matchers.stream().allMatch(entry -> {
                Matcher matcher = entry;
                return IntStream.range(0, GenomeSelectionDialog.this.table.getColumnCount()).anyMatch(index -> {
                    matcher.reset(GenomeSelectionDialog.this.table.getColumnName(index).toLowerCase());
                    if (matcher.find()) {
                        return true;
                    }
                    return matcher.reset(value.getStringValue(index)).find();
                });
            });
        }
    }
}

