/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.commandbar;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.genome.GenomeListItem;
import org.igv.ui.genome.GenomeListManager;
import org.igv.ui.util.MessageUtils;
import org.igv.util.LongRunningTask;

public class GenomeComboBox
extends JComboBox<GenomeListItem> {
    private static final Logger log = LogManager.getLogger(GenomeComboBox.class);

    public GenomeComboBox() {
        this.setRenderer(new ComboBoxRenderer());
        this.addActionListener(new GenomeBoxActionListener());
    }

    public void refreshGenomeListComboBox() {
        this.setModel(this.buildModel());
        String curId = GenomeManager.getInstance().getGenomeId();
        if (curId == null) {
            return;
        }
        int c = this.getItemCount();
        for (int i = 0; i < c; ++i) {
            GenomeListItem item = (GenomeListItem)this.getItemAt(i);
            if (!curId.equals(item.getId())) continue;
            this.setSelectedItem(item);
            break;
        }
    }

    private DefaultComboBoxModel<GenomeListItem> buildModel() {
        Collection<GenomeListItem> genomes;
        try {
            genomes = GenomeListManager.getInstance().getGenomeItemMap().values();
        }
        catch (IOException e) {
            log.error("Error reading genome list ", e);
            genomes = new ArrayList<GenomeListItem>();
            MessageUtils.showErrorMessage("Error reading genome list ", e);
        }
        Vector<GenomeListItem> vector = new Vector<GenomeListItem>(genomes);
        vector.sort(Comparator.comparing(GenomeListItem::getDisplayableName));
        return new DefaultComboBoxModel<GenomeListItem>(vector);
    }

    static class ComboBoxRenderer
    implements ListCellRenderer<GenomeListItem> {
        JSeparator separator = new JSeparator(0);

        @Override
        public Component getListCellRendererComponent(JList<? extends GenomeListItem> list, GenomeListItem value, int index, boolean isSelected, boolean cellHasFocus) {
            JLabel renderer;
            String text;
            String string = text = value == null ? "" : value.toString();
            if ("--SEPARATOR--".equals(text)) {
                return this.separator;
            }
            if (text.equals("Remove Imported Genomes...")) {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                renderer = label;
            } else {
                JLabel label = new JLabel(text);
                label.setOpaque(true);
                label.setBorder(new EmptyBorder(1, 1, 1, 1));
                label.setSize(label.getWidth() + 10, label.getHeight());
                renderer = label;
            }
            if (list != null) {
                if (isSelected) {
                    ((Component)renderer).setBackground(list.getSelectionBackground());
                    ((Component)renderer).setForeground(list.getSelectionForeground());
                } else {
                    ((Component)renderer).setBackground(list.getBackground());
                    ((Component)renderer).setForeground(list.getForeground());
                }
                ((Component)renderer).setFont(list.getFont());
            }
            return renderer;
        }
    }

    class GenomeBoxActionListener
    implements ActionListener {
        GenomeBoxActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object selItem = GenomeComboBox.this.getSelectedItem();
            if (!(selItem instanceof GenomeListItem)) {
                return;
            }
            GenomeListItem genomeListItem = (GenomeListItem)selItem;
            if (genomeListItem.getId().equalsIgnoreCase(GenomeManager.getInstance().getGenomeId())) {
                return;
            }
            Runnable runnable = () -> {
                if (genomeListItem.getPath() != null) {
                    try {
                        GenomeManager.getInstance().loadGenome(genomeListItem.getPath());
                    }
                    catch (Exception e) {
                        log.error(e);
                        MessageUtils.showErrorMessage("The genome '" + genomeListItem.getDisplayableName() + "' could not be read.", e);
                    }
                }
            };
            if (SwingUtilities.isEventDispatchThread()) {
                LongRunningTask.submit(runnable);
            } else {
                runnable.run();
            }
        }
    }
}

