/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.color;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.util.List;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import org.igv.ui.color.ColorPanel;
import org.igv.ui.color.ColorUtilities;

public class PaletteToolFrame
extends JFrame {
    private JMenuBar menuBar1;
    private JMenu menu1;
    private JMenuItem saveItem;
    private JPanel hSpacer1;
    private JCheckBox desaturateCheckbox;
    private ColorPanel colorPanel;

    public PaletteToolFrame() {
        this.initComponents();
        this.desaturateCheckbox.setSelected(this.colorPanel.showGrayScale);
    }

    private void saveItemActionPerformed(ActionEvent e) {
        List<ColorPanel.Palette> paletteList = this.colorPanel.paletteList;
        if (paletteList != null) {
            FileDialog fd = new FileDialog(this);
            fd.setMode(1);
            fd.setVisible(true);
            String f = fd.getFile();
            if (f != null) {
                try {
                    File file = new File(fd.getDirectory(), f);
                    PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));
                    for (ColorPanel.Palette p : paletteList) {
                        pw.println(p.label);
                        for (ColorPanel.Swatch s : p.swatches) {
                            pw.println(ColorUtilities.colorToString(s.color));
                        }
                    }
                }
                catch (Exception e1) {
                    e1.printStackTrace();
                }
            }
        }
    }

    private void showGrayScaleActionPerformed(ActionEvent e) {
        this.colorPanel.showGrayScale = this.desaturateCheckbox.isSelected();
        this.colorPanel.repaint();
    }

    private void initComponents() {
        this.menuBar1 = new JMenuBar();
        this.menu1 = new JMenu();
        this.saveItem = new JMenuItem();
        this.hSpacer1 = new JPanel(null);
        this.desaturateCheckbox = new JCheckBox();
        this.colorPanel = new ColorPanel();
        this.setDefaultCloseOperation(3);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this.menu1.setText("File");
        this.saveItem.setText("Save...");
        this.saveItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteToolFrame.this.saveItemActionPerformed(e);
            }
        });
        this.menu1.add(this.saveItem);
        this.menuBar1.add(this.menu1);
        this.menuBar1.add(this.hSpacer1);
        this.desaturateCheckbox.setText("De-saturate");
        this.desaturateCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PaletteToolFrame.this.showGrayScaleActionPerformed(e);
            }
        });
        this.menuBar1.add(this.desaturateCheckbox);
        this.setJMenuBar(this.menuBar1);
        contentPane.add((Component)this.colorPanel, "Center");
        this.setSize(890, 570);
        this.setLocationRelativeTo(this.getOwner());
    }

    public static void main(String[] args) {
        new PaletteToolFrame().setVisible(true);
    }
}

