/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.igv.ui.util.IGVMouseInputAdapter;

public class ColorSwatch
extends JPanel {
    private Color selectedColor;
    private ArrayList<ColorChangeListener> listeners;

    public ColorSwatch(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.listeners = new ArrayList();
        this.setPreferredSize(new Dimension(15, 15));
        this.setBorder(BorderFactory.createBevelBorder(0));
        this.setBackground(selectedColor);
        this.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent mouseEvent) {
                ColorSwatch.this.changeColorAction(mouseEvent);
            }
        });
    }

    public void setSelectedColor(Color selectedColor) {
        this.selectedColor = selectedColor;
        this.setBackground(selectedColor);
    }

    public void addColorChangeListener(ColorChangeListener listener) {
        this.listeners.add(listener);
    }

    private void changeColorAction(MouseEvent mouseEvent) {
        final JColorChooser colorChooser = new JColorChooser(this.selectedColor);
        JDialog dialog = JColorChooser.createDialog(this, "Select color", true, colorChooser, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Color c = colorChooser.getColor();
                if (c != null && !c.equals(ColorSwatch.this.selectedColor)) {
                    ColorSwatch.this.setSelectedColor(c);
                    for (ColorChangeListener l : ColorSwatch.this.listeners) {
                        l.colorChanged(c);
                    }
                }
            }
        }, null);
        dialog.setVisible(true);
    }

    public static void main(String[] args) {
        JFrame f = new JFrame("Example");
        f.setLayout(new FlowLayout());
        f.setSize(400, 400);
        ColorSwatch colorSwatch = new ColorSwatch(Color.BLUE);
        colorSwatch.addColorChangeListener(c -> {
            if (c != null) {
                float[] components = c.getRGBComponents(new float[4]);
                int r = (int)(components[0] * 255.0f);
                int g = (int)(components[1] * 255.0f);
                int b = (int)(components[2] * 255.0f);
                System.out.println(r + "," + g + "," + b);
            }
        });
        f.add(colorSwatch);
        f.setVisible(true);
    }

    public static interface ColorChangeListener {
        public void colorChanged(Color var1);
    }
}

