/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.io.File;
import org.igv.batch.BatchRunner;
import org.igv.logging.Level;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.IGV;
import org.igv.ui.action.LoadFilesMenuAction;
import org.igv.ui.action.MenuAction;
import org.igv.ui.util.FileDialogUtils;
import org.igv.ui.util.MessageUtils;

public class RunScriptMenuAction
extends MenuAction {
    static Logger log = LogManager.getLogger(LoadFilesMenuAction.class);
    IGV igv;

    public RunScriptMenuAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File[] script;
        if (e.getActionCommand().equalsIgnoreCase("run batch script...") && (script = this.chooseScriptFile()) != null && script.length > 0) {
            for (File f : script) {
                BatchRunner bRun = new BatchRunner(f.getPath(), this.igv);
                try {
                    bRun.run();
                }
                catch (Exception ex) {
                    MessageUtils.showMessage(Level.ERROR, "Error running batch script: " + ex.getMessage());
                }
            }
        }
    }

    private File[] chooseScriptFile() {
        File lastDirectoryFile = PreferencesManager.getPreferences().getLastTrackDirectory();
        File[] scriptFile = FileDialogUtils.chooseMultiple("Select Script", lastDirectoryFile, null);
        if (scriptFile != null && scriptFile.length > 0) {
            PreferencesManager.getPreferences().setLastTrackDirectory(scriptFile[0].getParentFile());
        }
        this.igv.resetStatusMessage();
        return scriptFile;
    }
}

