/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui.action;

import java.awt.event.ActionEvent;
import java.util.List;
import org.igv.feature.genome.HostedGenomes;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ui.IGV;
import org.igv.ui.action.MenuAction;
import org.igv.ui.genome.GenomeListItem;
import org.igv.ui.genome.GenomeSelectionDialog;
import org.igv.ui.genome.GenomeTableModel;

public class GenomeSelectionAction
extends MenuAction {
    private static Logger log = LogManager.getLogger(GenomeSelectionAction.class);
    private static String[] defaultHeaders = new String[]{"common name", "scientific name", "assembly", "accession"};
    IGV igv;
    GenomeSelectionDialog genomeSelectionDialog;

    public GenomeSelectionAction(String label, int mnemonic, IGV igv) {
        super(label, null, mnemonic);
        this.igv = igv;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        GenomeSelectionDialog dlg = this.getGenomeSelectionDialog();
        dlg.setVisible(true);
    }

    private GenomeSelectionDialog getGenomeSelectionDialog() {
        if (this.genomeSelectionDialog == null) {
            List<GenomeListItem> records = HostedGenomes.getRecords();
            String[] headers = defaultHeaders;
            GenomeTableModel model = new GenomeTableModel(headers, records);
            this.genomeSelectionDialog = new GenomeSelectionDialog(IGV.getInstance().getMainFrame(), model);
            this.genomeSelectionDialog.setTitle("Genomes");
        }
        return this.genomeSelectionDialog;
    }
}

