/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JSeparator;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.plaf.basic.BasicBorders;
import org.igv.DirectoryManager;
import org.igv.Globals;
import org.igv.aws.S3LoadDialog;
import org.igv.batch.CommandExecutor;
import org.igv.charts.ScatterPlotUtils;
import org.igv.encode.EncodeTrackChooserFactory;
import org.igv.feature.genome.ChromSizesUtils;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.lists.GeneListManagerUI;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.oauth.OAuthProvider;
import org.igv.oauth.OAuthUtils;
import org.igv.prefs.PreferencesManager;
import org.igv.tools.IgvToolsGui;
import org.igv.tools.motiffinder.MotifFinderPlugin;
import org.igv.track.AttributeManager;
import org.igv.track.CombinedDataSourceDialog;
import org.igv.track.Track;
import org.igv.ucsc.hub.Hub;
import org.igv.ucsc.hub.HubDescriptor;
import org.igv.ucsc.hub.HubRegistry;
import org.igv.ucsc.hub.HubSelectionDialog;
import org.igv.ui.AboutDialog;
import org.igv.ui.DesktopIntegration;
import org.igv.ui.DynamicMenuItemsAdjustmentListener;
import org.igv.ui.IGV;
import org.igv.ui.MenuSelectedListener;
import org.igv.ui.action.BrowseEncodeAction;
import org.igv.ui.action.ExportRegionsMenuAction;
import org.igv.ui.action.ExportTrackNamesMenuAction;
import org.igv.ui.action.FilterTracksMenuAction;
import org.igv.ui.action.GenomeSelectionAction;
import org.igv.ui.action.GroupTracksMenuAction;
import org.igv.ui.action.ImportRegionsMenuAction;
import org.igv.ui.action.LoadFilesMenuAction;
import org.igv.ui.action.LoadFromServerAction;
import org.igv.ui.action.LoadFromURLMenuAction;
import org.igv.ui.action.MenuAction;
import org.igv.ui.action.NavigateRegionsMenuAction;
import org.igv.ui.action.NewSessionMenuAction;
import org.igv.ui.action.OpenSessionMenuAction;
import org.igv.ui.action.ReloadSessionMenuAction;
import org.igv.ui.action.RenameTracksMenuAction;
import org.igv.ui.action.ResetPreferencesAction;
import org.igv.ui.action.RunScriptMenuAction;
import org.igv.ui.action.SaveSessionMenuAction;
import org.igv.ui.action.SelectHubTracksAction;
import org.igv.ui.action.SortTracksMenuAction;
import org.igv.ui.commandbar.RemoveGenomesDialog;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.MainPanel;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.panel.ReorderPanelsDialog;
import org.igv.ui.util.AutosaveMenu;
import org.igv.ui.util.FileDialogUtils;
import org.igv.ui.util.HistoryMenu;
import org.igv.ui.util.MenuAndToolbarUtils;
import org.igv.ui.util.MessageUtils;
import org.igv.ui.util.UIUtilities;
import org.igv.util.AmazonUtils;
import org.igv.util.BrowserLauncher;
import org.igv.util.GoogleUtils;
import org.igv.util.LongRunningTask;
import org.igv.util.blat.BlatClient;

public class IGVMenuBar
extends JMenuBar {
    private static Logger log = LogManager.getLogger(IGVMenuBar.class);
    private static IGVMenuBar instance;
    private JMenu extrasMenu;
    private JMenu googleMenu;
    private JMenu AWSMenu;
    private AutosaveMenu autosaveMenu;
    private FilterTracksMenuAction filterTracksAction;
    private JMenu viewMenu;
    private IGV igv;
    private JMenuItem reloadSessionItem;
    private JMenuItem recentFilesMenu;
    private JMenuItem editAnnotationsItem;
    private JMenu fileMenu;
    private List<JComponent> tracksMenuAttributeComponents;
    private JMenu hubsMenu;

    static IGVMenuBar createInstance(IGV igv) {
        if (instance != null) {
            if (igv == IGVMenuBar.instance.igv) {
                return instance;
            }
            throw new IllegalStateException("Cannot create another IGVMenuBar, use getInstance");
        }
        UIUtilities.invokeAndWaitOnEventThread(() -> {
            instance = new IGVMenuBar(igv);
        });
        return instance;
    }

    public static IGVMenuBar getInstance() {
        return instance;
    }

    private IGVMenuBar(IGV igv) {
        this.igv = igv;
        this.setBorder(new BasicBorders.MenuBarBorder(Color.GRAY, Color.GRAY));
        this.setBorderPainted(true);
        for (AbstractButton menu : this.createMenus()) {
            this.add(menu);
        }
        if (Globals.IS_MAC) {
            DesktopIntegration.setAboutHandler(this);
            DesktopIntegration.setQuitHandler();
        }
    }

    public void showAboutDialog() {
        new AboutDialog(this.igv.getMainFrame(), true).setVisible(true);
    }

    private List<AbstractButton> createMenus() {
        ArrayList<AbstractButton> menus = new ArrayList<AbstractButton>();
        this.fileMenu = new JMenu("File");
        menus.add(this.fileMenu);
        menus.add(this.createGenomesMenu());
        this.hubsMenu = new JMenu("Track Hubs");
        menus.add(this.hubsMenu);
        menus.add(this.createSampleInfoMenu("Sample Info"));
        menus.add(this.createSessionsMenu("Sessions"));
        menus.add(this.createViewMenu("View"));
        menus.add(this.createRegionsMenu("Regions"));
        menus.add(this.createToolsMenu("Tools"));
        this.extrasMenu = this.createExtrasMenu("Extras");
        menus.add(this.extrasMenu);
        this.updateHubsMenu(GenomeManager.getInstance().getCurrentGenome());
        try {
            this.googleMenu = this.createGoogleMenu();
            if (this.googleMenu != null) {
                boolean enabled = PreferencesManager.getPreferences().getAsBoolean("ENABLE_GOOGLE_MENU");
                this.enableGoogleMenu(enabled);
                menus.add(this.googleMenu);
            }
        }
        catch (IOException e) {
            log.error("Error creating google menu: " + e.getMessage());
        }
        this.AWSMenu = this.createAWSMenu();
        this.AWSMenu.setVisible(false);
        menus.add(this.AWSMenu);
        LongRunningTask.submit(this::updateAWSMenu);
        menus.add(this.createHelpMenu());
        return menus;
    }

    public void updateAWSMenu() {
        UIUtilities.invokeOnEventThread(() -> this.AWSMenu.setVisible(AmazonUtils.isAwsProviderPresent()));
    }

    JMenu createToolsMenu(String name) {
        JMenu menuItems = new JMenu(name);
        MenuAction menuAction = new RunScriptMenuAction("Run Batch Script...", 88, this.igv);
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SortTracksMenuAction("Run igvtools...", 84, this.igv){

            @Override
            public void actionPerformed(ActionEvent e) {
                IgvToolsGui.launch(false, GenomeManager.getInstance().getGenomeId());
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(MotifFinderPlugin.getMenuItem());
        menuItems.add(IGVMenuBar.createBlatMenuItem());
        JMenuItem combineDataItem = new JMenuItem("Combine Data Tracks...");
        combineDataItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CombinedDataSourceDialog dialog = new CombinedDataSourceDialog(IGVMenuBar.this.igv.getMainFrame());
                dialog.setVisible(true);
            }
        });
        menuItems.add(combineDataItem);
        return menuItems;
    }

    public void enableExtrasMenu() {
        this.extrasMenu.setVisible(true);
    }

    JMenu updateFileMenu(Genome genome) {
        this.fileMenu.removeAll();
        MenuAction menuAction = new LoadFilesMenuAction("Load Tracks from File...", 76, this.igv);
        menuAction.setToolTipText("Load tracks");
        this.fileMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load Tracks from URL...", 85, this.igv);
        menuAction.setToolTipText("Load tracks");
        this.fileMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (genome != null && LoadFromServerAction.getNodeURLs(genome.getId()) != null && !LoadFromServerAction.getNodeURLs(genome.getId()).isEmpty()) {
            menuAction = new LoadFromServerAction("Load Tracks from Server...", 83, this.igv);
            menuAction.setToolTipText("Load tracks from a server");
            JMenuItem loadTracksFromServerMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
            this.fileMenu.add(loadTracksFromServerMenuItem);
        }
        this.fileMenu.addSeparator();
        menuAction = new MenuAction("Save PNG Image ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getMainPanel(), "png");
            }
        };
        menuAction.setToolTipText("Capture and save a PNG image");
        this.fileMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save SVG Image ...", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getMainPanel(), "svg");
            }
        };
        menuAction.setToolTipText("Capture and save an SVG image");
        this.fileMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        this.fileMenu.add(new JSeparator());
        menuAction = new MenuAction("Exit", null, 88){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.doExitApplication();
            }
        };
        menuAction.setToolTipText("Exit the application");
        this.fileMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        return this.fileMenu;
    }

    JMenu createSessionsMenu(String name) {
        JMenu menu = new JMenu(name);
        MenuAction menuAction = new NewSessionMenuAction("New Session...", 78, this.igv);
        menuAction.setToolTipText("Create a new session");
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new OpenSessionMenuAction("Load Session from File...", 79, this.igv);
        menuAction.setToolTipText("Load a session");
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load Session from URL...", 85, this.igv);
        menuAction.setToolTipText("Load a session");
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new SaveSessionMenuAction("Save Session...", 86, this.igv);
        menuAction.setToolTipText("Save the current session");
        JMenuItem saveSessionItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        menu.add(saveSessionItem);
        menu.add(new JSeparator());
        menuAction = new ReloadSessionMenuAction("Reload Session", -1, this.igv);
        menuAction.setToolTipText("Reload the current session");
        this.reloadSessionItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        this.reloadSessionItem.setEnabled(false);
        menu.add(this.reloadSessionItem);
        menu.add(new JSeparator());
        this.autosaveMenu = new AutosaveMenu();
        menu.add(this.autosaveMenu);
        JSeparator recentSessionsSep = new JSeparator();
        recentSessionsSep.setVisible(false);
        menu.add(recentSessionsSep);
        menu.add(new JSeparator());
        menu.addMenuListener(new DynamicMenuItemsAdjustmentListener<String>(menu, recentSessionsSep, IGV.getInstance().getRecentSessionList(), session -> MenuAndToolbarUtils.createMenuItem(new OpenSessionMenuAction((String)session, IGV.getInstance()))));
        return menu;
    }

    private JMenu createGenomesMenu() {
        JMenu menu = new JMenu("Genomes");
        GenomeSelectionAction genArkAction = new GenomeSelectionAction("Load Genome from Host ...", 0, this.igv);
        menu.add(MenuAndToolbarUtils.createMenuItem(genArkAction));
        JMenuItem fileItem = new JMenuItem("Load Genome from File...", 73);
        fileItem.addActionListener(e -> {
            try {
                File file;
                File importDirectory = PreferencesManager.getPreferences().getLastGenomeImportDirectory();
                if (importDirectory == null) {
                    PreferencesManager.getPreferences().setLastGenomeImportDirectory(DirectoryManager.getUserDefaultDirectory());
                }
                if ((file = FileDialogUtils.chooseFile("Load Genome", importDirectory, 0)) != null) {
                    GenomeManager.getInstance().loadGenome(file.getAbsolutePath());
                }
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage(ex.getMessage(), ex);
            }
        });
        fileItem.setToolTipText("Load a FASTA, .json, or .genome file...");
        menu.add(fileItem);
        LoadFromURLMenuAction urlMenuAction = new LoadFromURLMenuAction("Load Genome from URL...", 0, this.igv);
        urlMenuAction.setToolTipText("Load a FASTA, .json, or .genome file...");
        menu.add(MenuAndToolbarUtils.createMenuItem(urlMenuAction));
        Genome currentGenome = GenomeManager.getInstance().getCurrentGenome();
        menu.add(new JSeparator());
        this.editAnnotationsItem = new JMenuItem("Select Default Annotations ...", 69);
        this.editAnnotationsItem.addActionListener(e -> {
            try {
                GenomeManager.getInstance().updateAnnotations();
            }
            catch (IOException ex) {
                log.error("Error updating annotations", ex);
            }
        });
        this.editAnnotationsItem.setEnabled(currentGenome != null && currentGenome.getGenomeHub() != null);
        menu.add(this.editAnnotationsItem);
        menu.add(new JSeparator());
        MenuAction menuAction = new MenuAction("Remove Genomes...", null){

            @Override
            public void actionPerformed(ActionEvent event) {
                RemoveGenomesDialog dialog2 = new RemoveGenomesDialog(IGVMenuBar.this.igv.getMainFrame());
                dialog2.setVisible(true);
            }
        };
        menuAction.setToolTipText("Remove genomes which appear in the dropdown list");
        menu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        return menu;
    }

    private JMenu createSampleInfoMenu(String name) {
        JMenu tracksMenu = new JMenu(name);
        MenuAction menuAction = new LoadFilesMenuAction("Load Sample Info from File...", 76, this.igv, LoadFilesMenuAction.Type.SAMPLE_INFO);
        tracksMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new LoadFromURLMenuAction("Load Sample Info from URL...", 85, this.igv);
        tracksMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        tracksMenu.addSeparator();
        this.tracksMenuAttributeComponents = new ArrayList<JComponent>();
        menuAction = new SortTracksMenuAction("Sort Samples by Attribute...", 83, IGV.getInstance());
        JMenuItem sortTracksMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        tracksMenu.add(sortTracksMenuItem);
        this.tracksMenuAttributeComponents.add(sortTracksMenuItem);
        menuAction = new GroupTracksMenuAction("Group Samples by Attribute... ", 71, IGV.getInstance());
        JMenuItem groupTracksMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        tracksMenu.add(groupTracksMenuItem);
        this.tracksMenuAttributeComponents.add(groupTracksMenuItem);
        this.filterTracksAction = new FilterTracksMenuAction("Filter Samples by Attribute...", 70, IGV.getInstance());
        JMenuItem filterTracksMenuItem = MenuAndToolbarUtils.createMenuItem(this.filterTracksAction);
        tracksMenu.add(filterTracksMenuItem);
        this.tracksMenuAttributeComponents.add(filterTracksMenuItem);
        menuAction = new RenameTracksMenuAction("Rename Samples by Attribute... ", 82, IGV.getInstance());
        JMenuItem renameTracksMenuItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        tracksMenu.add(renameTracksMenuItem);
        this.tracksMenuAttributeComponents.add(renameTracksMenuItem);
        JMenuItem exportNames = new JMenuItem("Export Track Names and Attributes...");
        exportNames.addActionListener(e12 -> {
            List<Track> exportTracks = IGV.getInstance().getSelectedTracks();
            if (exportTracks.size() <= 1) {
                exportTracks = IGV.getInstance().getAllTracks();
            }
            this.exportTrackNames(exportTracks);
        });
        tracksMenu.add(exportNames);
        tracksMenu.addMenuListener(new MenuListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean hasAttributes = AttributeManager.getInstance().getAttributeNames().size() > 0;
                for (JComponent comp : IGVMenuBar.this.tracksMenuAttributeComponents) {
                    comp.setEnabled(hasAttributes);
                }
            }

            @Override
            public void menuDeselected(MenuEvent e) {
            }

            @Override
            public void menuCanceled(MenuEvent e) {
            }
        });
        return tracksMenu;
    }

    private JMenu createViewMenu(String name) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("Preferences...", null, 80){

            @Override
            public void actionPerformed(ActionEvent e) {
                UIUtilities.invokeOnEventThread(new Runnable(){

                    @Override
                    public void run() {
                        IGVMenuBar.this.igv.doViewPreferences();
                    }
                });
            }
        };
        menuAction.setToolTipText("Set user specific preferences");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Show Name Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                if (menuItem.isSelected()) {
                    IGVMenuBar.this.igv.getMainPanel().expandNamePanel();
                } else {
                    IGVMenuBar.this.igv.getMainPanel().collapseNamePanel();
                }
            }
        };
        boolean isShowing = this.igv.getMainPanel().isExpanded();
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem();
        menuItem.setSelected(isShowing);
        menuItem.setAction(menuAction);
        menuItems.add(menuItem);
        JMenuItem panelWidthmenuItem = new JMenuItem();
        menuAction = new MenuAction("Set Name Panel Width...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                MainPanel mainPanel = IGVMenuBar.this.igv.getMainPanel();
                String currentValue = String.valueOf(mainPanel.getNamePanelWidth());
                String newValue = MessageUtils.showInputDialog("Enter track name panel width: ", currentValue);
                if (newValue != null) {
                    try {
                        Integer w = Integer.parseInt(newValue);
                        if (w <= 0) {
                            throw new NumberFormatException();
                        }
                        PreferencesManager.getPreferences().put("NAME_PANEL_WIDTH", newValue);
                        mainPanel.setNamePanelWidth(w);
                    }
                    catch (NumberFormatException ex) {
                        MessageUtils.showErrorMessage("Error: value must be a positive integer.", ex);
                    }
                }
            }
        };
        panelWidthmenuItem.setAction(menuAction);
        menuItems.add(panelWidthmenuItem);
        menuAction = new MenuAction("Show Attribute Display", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                PreferencesManager.getPreferences().setShowAttributeView(menuItem.getState());
                IGVMenuBar.this.igv.revalidateTrackPanels();
            }
        };
        boolean isShow = PreferencesManager.getPreferences().getAsBoolean("IGV.track.show.attribute.views");
        menuItem = MenuAndToolbarUtils.createMenuItem(menuAction, isShow);
        menuItems.add(menuItem);
        menuAction = new MenuAction("Select Attributes to Show...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.doSelectDisplayableAttribute();
            }
        };
        menuAction.setToolTipText("Customize attribute display to show only checked attributes");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Show Header Panel", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCheckBoxMenuItem menuItem = (JCheckBoxMenuItem)e.getSource();
                if (menuItem.isSelected()) {
                    IGVMenuBar.this.igv.getMainPanel().restoreHeader();
                } else {
                    IGVMenuBar.this.igv.getMainPanel().removeHeader();
                }
                IGVMenuBar.this.igv.getMainPanel().revalidate();
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction, true));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Reorder Panels...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReorderPanelsDialog dlg = new ReorderPanelsDialog(IGVMenuBar.this.igv.getMainFrame());
                dlg.setVisible(true);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Add New Panel", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                String newPanelName = "Panel" + System.currentTimeMillis();
                IGVMenuBar.this.igv.addDataPanel(newPanelName);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuItems.add(new HistoryMenu("Go to"));
        MenuAction dataMenuAction = new MenuAction(name, null, 86);
        this.viewMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return this.viewMenu;
    }

    private JMenu createRegionsMenu(String name) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new NavigateRegionsMenuAction("Region Navigator ...", IGV.getInstance());
        menuAction.setToolTipText("Navigate regions");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Gene Lists...", null, 83){

            @Override
            public void actionPerformed(ActionEvent e) {
                GeneListManagerUI.getInstance(IGVMenuBar.this.igv.getMainFrame()).setVisible(true);
            }
        };
        menuAction.setToolTipText("Open gene list manager");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new ExportRegionsMenuAction("Export Regions ...", 69, IGV.getInstance());
        menuAction.setToolTipText("Save all defined regions to a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ImportRegionsMenuAction("Import Regions ...", 73, IGV.getInstance());
        menuAction.setToolTipText("Load regions from a file");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction dataMenuAction = new MenuAction(name, null, 86);
        JMenu regionMenu = MenuAndToolbarUtils.createMenu(menuItems, dataMenuAction);
        return regionMenu;
    }

    private void updateHubsMenu(Genome genome) {
        List<HubDescriptor> hubs;
        List<HubDescriptor> selectedHubs;
        String ucscId;
        if (genome == null) {
            return;
        }
        this.hubsMenu.removeAll();
        if (genome.getTrackHubs().size() > 0) {
            for (Hub trackHub : genome.getTrackHubs()) {
                this.hubsMenu.add(this.createTrackHubItem(trackHub.getDescriptor(), genome.getUCSCId()));
            }
        }
        if (EncodeTrackChooserFactory.genomeSupportedUCSC(ucscId = genome.getUCSCId()) || EncodeTrackChooserFactory.genomeSupported(ucscId)) {
            if (EncodeTrackChooserFactory.genomeSupported(ucscId)) {
                JMenuItem chipItem = new JMenuItem();
                chipItem.setAction(new BrowseEncodeAction("ENCODE ChIP Signals ...", 0, BrowseEncodeAction.Type.SIGNALS_CHIP, this.igv));
                this.hubsMenu.add(chipItem);
                JMenuItem otherSignalsItem = new JMenuItem();
                otherSignalsItem.setAction(new BrowseEncodeAction("ENCODE Other Signals ...", 0, BrowseEncodeAction.Type.SIGNALS_OTHER, this.igv));
                this.hubsMenu.add(otherSignalsItem);
                if (EncodeTrackChooserFactory.hicSupportedUCSC(ucscId)) {
                    JMenuItem hicSignalsItem = new JMenuItem();
                    hicSignalsItem.setAction(new BrowseEncodeAction("ENCODE Contact Maps ...", 0, BrowseEncodeAction.Type.HIC, this.igv));
                    this.hubsMenu.add(hicSignalsItem);
                }
                JMenuItem otherItem = new JMenuItem();
                otherItem.setAction(new BrowseEncodeAction("ENCODE Other ...", 0, BrowseEncodeAction.Type.OTHER, this.igv));
                this.hubsMenu.add(otherItem);
            }
            if (EncodeTrackChooserFactory.genomeSupportedUCSC(ucscId)) {
                JMenuItem encodeUCSCMenuItem = MenuAndToolbarUtils.createMenuItem(new BrowseEncodeAction("ENCODE 2012 UCSC Repository ...", 69, BrowseEncodeAction.Type.UCSC, this.igv));
                this.hubsMenu.add(encodeUCSCMenuItem);
            }
            if ("hg38".equals(ucscId)) {
                JMenuItem fdnItem = new JMenuItem();
                fdnItem.setAction(new BrowseEncodeAction("4DN ...", 0, BrowseEncodeAction.Type.FOUR_DN, this.igv));
                this.hubsMenu.add(fdnItem);
            }
        }
        if ((selectedHubs = HubRegistry.getSelectedHubsForGenome(genome.getUCSCId())) != null && selectedHubs.size() > 0) {
            this.hubsMenu.addSeparator();
            for (HubDescriptor hub : selectedHubs) {
                this.hubsMenu.add(this.createTrackHubItem(hub, genome.getUCSCId()));
            }
        }
        if (this.hubsMenu.getItemCount() > 0) {
            this.hubsMenu.addSeparator();
        }
        if (!(hubs = HubRegistry.getAllHubsForGenome(genome.getUCSCId())).isEmpty()) {
            JMenuItem addHubItem = new JMenuItem("Select Track Hubs ...");
            addHubItem.addActionListener(e -> {
                HubSelectionDialog hubSelectionDialog = new HubSelectionDialog(this.igv.getMainFrame());
                hubSelectionDialog.setVisible(true);
                if (!hubSelectionDialog.isCanceled()) {
                    List<HubDescriptor> selected = hubSelectionDialog.getSelectedHubs();
                    HubRegistry.setSelectedHubs(selected);
                    this.updateHubsMenu(GenomeManager.getInstance().getCurrentGenome());
                }
            });
            this.hubsMenu.add(addHubItem);
        }
        LoadFromURLMenuAction menuAction = new LoadFromURLMenuAction("Add Track Hub from URL...", 72, this.igv);
        this.hubsMenu.add(MenuAndToolbarUtils.createMenuItem(menuAction));
    }

    private JMenu createHelpMenu() {
        Desktop desktop;
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        MenuAction menuAction = null;
        menuAction = new MenuAction("User Guide ... "){

            @Override
            public void actionPerformed(ActionEvent e) {
                try {
                    BrowserLauncher.openURL("http://www.broadinstitute.org/igv/UserGuide");
                }
                catch (IOException ex) {
                    log.error("Error opening browser", ex);
                }
            }
        };
        menuAction.setToolTipText("Open web help page");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        if (Desktop.isDesktopSupported() && (desktop = Desktop.getDesktop()).isSupported(Desktop.Action.MAIL)) {
            menuAction = new MenuAction("Help Forum..."){

                @Override
                public void actionPerformed(ActionEvent e) {
                    try {
                        URI uri = new URI("http://groups.google.com/forum/#!forum/igv-help");
                        Desktop.getDesktop().browse(uri);
                    }
                    catch (Exception ex) {
                        log.error("Error opening igv-help uri", ex);
                    }
                }
            };
            menuAction.setToolTipText("Email support");
            menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        }
        menuAction = new MenuAction("About IGV "){

            @Override
            public void actionPerformed(ActionEvent e) {
                new AboutDialog(IGVMenuBar.this.igv.getMainFrame(), true).setVisible(true);
            }
        };
        menuAction.setToolTipText("Display application information");
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction helpMenuAction = new MenuAction("Help");
        return MenuAndToolbarUtils.createMenu(menuItems, helpMenuAction);
    }

    private JMenu createExtrasMenu(String name) {
        ArrayList<JComponent> menuItems = new ArrayList<JComponent>();
        JMenuItem memTest = new JMenuItem("Memory test");
        memTest.addActionListener(e -> {
            try {
                CommandExecutor exe = new CommandExecutor(this.igv);
                int count = 1;
                int start = 0;
                exe.execute("snapshotDirectory /Users/jrobinso/Downloads/tmp");
                while (count++ < 10000) {
                    exe.execute("goto chr1:" + start + "-" + (start + 1000));
                    exe.execute("snapshot");
                    start += 1000;
                }
            }
            catch (IOException ex) {
                log.error("Error executing command", ex);
            }
        });
        menuItems.add(memTest);
        MenuAction menuAction = null;
        menuAction = new ResetPreferencesAction("Reset Preferences", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuItems.add(new JSeparator());
        menuAction = new MenuAction("Set window dimensions", null, 67){

            @Override
            public void actionPerformed(ActionEvent e) {
                String[] vals;
                String value = JOptionPane.showInputDialog("Enter dimensions, e.g. 800x400");
                if (value != null && (vals = value.split("x")).length == 2) {
                    int w = Integer.parseInt(vals[0]);
                    int h = Integer.parseInt(vals[1]);
                    IGVMenuBar.this.igv.getMainFrame().setSize(w, h);
                }
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save PNG Screenshot ...", null, 65){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getContentPane(), "png");
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Save SVG Screenshot ...", null){

            @Override
            public void actionPerformed(ActionEvent e) {
                IGVMenuBar.this.igv.saveImage(IGVMenuBar.this.igv.getContentPane(), "svg");
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new ExportTrackNamesMenuAction("Export track names...", IGV.getInstance());
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        menuAction = new MenuAction("Scatter Plot ..."){

            @Override
            public void actionPerformed(ActionEvent e) {
                ReferenceFrame defaultFrame = FrameManager.getDefaultFrame();
                String chr = defaultFrame.getChrName();
                int start = (int)defaultFrame.getOrigin();
                int end = (int)defaultFrame.getEnd();
                int zoom = defaultFrame.getZoom();
                ScatterPlotUtils.openPlot(chr, start, end, zoom);
            }
        };
        menuItems.add(MenuAndToolbarUtils.createMenuItem(menuAction));
        MenuAction extrasMenuAction = new MenuAction(name);
        JMenu menu = MenuAndToolbarUtils.createMenu(menuItems, extrasMenuAction);
        JMenu lfMenu = new JMenu("L&F");
        LookAndFeel lf = UIManager.getLookAndFeel();
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            final String lfName = info.getName();
            JMenuItem cb = new JMenuItem(lfName);
            cb.addActionListener(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!lfName.equals(info.getName())) continue;
                        try {
                            UIManager.setLookAndFeel(info.getClassName());
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break;
                    }
                }
            });
            lfMenu.add(cb);
        }
        menu.add(lfMenu);
        JMenuItem updateCS = new JMenuItem("Update chrom sizes");
        updateCS.addActionListener(e -> {
            try {
                ChromSizesUtils.main(new String[0]);
            }
            catch (IOException ioException) {
                ioException.printStackTrace();
            }
        });
        menu.add(updateCS);
        menu.setVisible(false);
        return menu;
    }

    private JMenu createAWSMenu() {
        boolean usingCognito = AmazonUtils.GetCognitoConfig() != null;
        JMenu menu = new JMenu("Amazon");
        final JMenuItem login = new JMenuItem("Login");
        login.addActionListener(e -> {
            try {
                OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
                oauth.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        });
        login.setEnabled(usingCognito);
        login.setVisible(usingCognito);
        menu.add(login);
        final JMenuItem logout = new JMenuItem("Logout");
        logout.addActionListener(e -> {
            OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
            oauth.logout();
        });
        logout.setEnabled(false);
        logout.setVisible(usingCognito);
        menu.add(logout);
        final JMenuItem loadS3 = new JMenuItem("Load from S3 bucket");
        loadS3.addActionListener(e -> {
            List<String> buckets = AmazonUtils.ListBucketsForUser();
            log.debug(buckets);
            UIUtilities.invokeOnEventThread(() -> {
                S3LoadDialog dlg = new S3LoadDialog(this.igv.getMainFrame());
                dlg.setModal(true);
                dlg.setVisible(true);
                dlg.dispose();
            });
        });
        loadS3.setEnabled(!usingCognito);
        menu.add(loadS3);
        menu.addMenuListener(new MenuSelectedListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                if (AmazonUtils.GetCognitoConfig() != null) {
                    Runnable runnable = () -> {
                        OAuthProvider oauth = OAuthUtils.getInstance().getAWSProvider();
                        boolean loggedIn = oauth.isLoggedIn();
                        log.debug("MenuBar is user loggedIn?: " + loggedIn);
                        if (loggedIn) {
                            login.setText(oauth.getCurrentUserName());
                        } else {
                            login.setText("Login ...");
                        }
                        login.setVisible(true);
                        logout.setVisible(true);
                        login.setEnabled(!loggedIn);
                        logout.setEnabled(loggedIn);
                        loadS3.setEnabled(loggedIn);
                    };
                    LongRunningTask.submit(runnable);
                }
            }
        });
        return menu;
    }

    private JMenu createGoogleMenu() {
        final OAuthProvider googleProvider = OAuthUtils.getInstance().getGoogleProvider();
        if (googleProvider == null) {
            log.error("Error creating google oauth provider");
            return null;
        }
        this.googleMenu = new JMenu("Google");
        final JMenuItem login = new JMenuItem("Login ... ");
        login.addActionListener(e -> {
            try {
                googleProvider.openAuthorizationPage();
            }
            catch (Exception ex) {
                MessageUtils.showErrorMessage("Error fetching oAuth tokens.  See log for details", ex);
                log.error("Error fetching oAuth tokens", ex);
            }
        });
        this.googleMenu.add(login);
        final JMenuItem logout = new JMenuItem("Logout ");
        logout.addActionListener(e -> {
            googleProvider.logout();
            GoogleUtils.setProjectID(null);
        });
        this.googleMenu.add(logout);
        JMenuItem projectID = new JMenuItem("Enter Project ID ...");
        projectID.addActionListener(e -> GoogleUtils.enterGoogleProjectID());
        this.googleMenu.add(projectID);
        this.googleMenu.addMenuListener(new MenuSelectedListener(){

            @Override
            public void menuSelected(MenuEvent e) {
                boolean loggedIn = googleProvider.isLoggedIn();
                if (loggedIn && googleProvider.getCurrentUserName() != null) {
                    login.setText(googleProvider.getCurrentUserName());
                } else {
                    login.setText("Login ...");
                }
                login.setEnabled(!loggedIn);
                logout.setEnabled(loggedIn);
            }
        });
        return this.googleMenu;
    }

    public void enableGoogleMenu(boolean enable) throws IOException {
        if (this.googleMenu != null) {
            this.googleMenu.setVisible(enable);
        }
    }

    public void resetSessionActions() {
    }

    public final void doExitApplication() {
        try {
            this.igv.saveStateForExit();
            Frame mainFrame = this.igv.getMainFrame();
            PreferencesManager.getPreferences().setApplicationFrameBounds(mainFrame.getBounds());
            mainFrame.setVisible(false);
            mainFrame.dispose();
        }
        finally {
            System.exit(0);
        }
    }

    static void destroyInstance() {
        instance = null;
    }

    public synchronized void updateMenus(Genome genome) {
        if (genome != null) {
            UIUtilities.invokeOnEventThread(() -> {
                this.updateHubsMenu(genome);
                this.updateFileMenu(genome);
                this.editAnnotationsItem.setEnabled(genome.getGenomeHub() != null);
            });
        }
    }

    public void setAllMenusEnabled(boolean enabled) {
        for (int i = 0; i < this.getMenuCount(); ++i) {
            JMenu menu = this.getMenu(i);
            if (menu == null) continue;
            this.setMenuComponentsEnabled(menu, enabled);
        }
    }

    private void setMenuComponentsEnabled(JMenu menu, boolean enabled) {
        menu.setEnabled(enabled);
        for (Component component : menu.getMenuComponents()) {
            if (component instanceof JMenu) {
                this.setMenuComponentsEnabled((JMenu)component, enabled);
                continue;
            }
            component.setEnabled(enabled);
        }
    }

    public void enableReloadSession() {
        if (this.reloadSessionItem != null) {
            this.reloadSessionItem.setEnabled(true);
        }
    }

    public void showRecentFilesMenu() {
        if (this.recentFilesMenu != null) {
            this.recentFilesMenu.setVisible(true);
        }
    }

    public void disableReloadSession() {
        if (this.reloadSessionItem != null) {
            this.reloadSessionItem.setEnabled(false);
        }
    }

    public static JMenuItem createBlatMenuItem() {
        JMenuItem menuItem = new JMenuItem("BLAT ...");
        menuItem.addActionListener(e -> {
            String blatSequence = MessageUtils.showInputDialog("Enter sequence to blat:");
            if (blatSequence != null) {
                if (blatSequence.length() < 20 || blatSequence.length() > 8000) {
                    MessageUtils.showMessage("BLAT sequences must be between 20 and 8000 bases in length.");
                } else {
                    BlatClient.doBlatQuery(blatSequence, "BLAT");
                }
            }
        });
        return menuItem;
    }

    private void exportTrackNames(Collection<Track> selectedTracks) {
        if (selectedTracks.isEmpty()) {
            return;
        }
        File file = FileDialogUtils.chooseFile("Export track names", PreferencesManager.getPreferences().getLastTrackDirectory(), new File("trackNames.txt"), FileDialogUtils.SAVE);
        if (file == null) {
            return;
        }
        try (PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(file)));){
            List<String> attributes = AttributeManager.getInstance().getVisibleAttributes();
            pw.print("Name");
            for (String att : attributes) {
                pw.print("\t" + att);
            }
            pw.println();
            for (Track track : selectedTracks) {
                pw.print(track.getName());
                for (String att : attributes) {
                    String val = track.getAttributeValue(att);
                    pw.print("\t" + (val == null ? "" : val));
                }
                pw.println();
            }
        }
        catch (IOException e) {
            MessageUtils.showErrorMessage("Error writing to file", e);
            log.error(e);
        }
    }

    private JMenuItem createTrackHubItem(HubDescriptor trackHub, String id) {
        SelectHubTracksAction menuAction = new SelectHubTracksAction(trackHub.getShortLabel() + "... ", trackHub, id);
        menuAction.setToolTipText(trackHub.getLongLabel());
        JMenuItem selectHubTracksItem = MenuAndToolbarUtils.createMenuItem(menuAction);
        selectHubTracksItem.setToolTipText(trackHub.getLongLabel());
        return selectHubTracksItem;
    }
}

