/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.hub;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.igv.feature.genome.load.TrackConfig;

public class TrackConfigContainer {
    public int priority;
    public String name;
    public String label;
    public boolean defaultOpen;
    public List<TrackConfig> tracks;
    public List<TrackConfigContainer> children;

    public TrackConfigContainer(String name, String label, int priority, boolean defaultOpen) {
        this.name = name;
        this.priority = priority;
        this.label = label;
        this.defaultOpen = defaultOpen;
        this.tracks = new ArrayList<TrackConfig>();
        this.children = new ArrayList<TrackConfigContainer>();
    }

    public boolean isEmpty() {
        return this.tracks.isEmpty() && (this.children == null || this.children.isEmpty() || this.children.stream().allMatch(TrackConfigContainer::isEmpty));
    }

    public void map(Function<TrackConfig, Void> f) {
        for (TrackConfig config : this.tracks) {
            f.apply(config);
        }
        for (TrackConfigContainer g : this.children) {
            g.map(f);
        }
    }

    public List<TrackConfig> findTracks(Function<TrackConfig, Boolean> filter) {
        ArrayList<TrackConfig> found = new ArrayList<TrackConfig>();
        this.find(found, filter);
        return found;
    }

    private void find(List<TrackConfig> found, Function<TrackConfig, Boolean> filter) {
        for (TrackConfig config : this.tracks) {
            if (!filter.apply(config).booleanValue()) continue;
            found.add(config);
        }
        for (TrackConfigContainer g : this.children) {
            g.find(found, filter);
        }
    }

    public int countTracks() {
        int count = this.tracks.size();
        for (TrackConfigContainer container : this.children) {
            count += container.countTracks();
        }
        return count;
    }

    public int countSelectedTracks() {
        int count = 0;
        for (TrackConfig trackConfig : this.tracks) {
            if (!trackConfig.visible.booleanValue()) continue;
            ++count;
        }
        for (TrackConfigContainer container : this.children) {
            count += container.countSelectedTracks();
        }
        return count;
    }

    public void trim() {
        this.children.stream().filter(c -> !c.isEmpty()).forEach(c -> c.trim());
    }

    public void setTrackVisibility(Set<String> loadedTrackPaths) {
        for (TrackConfig trackConfig : this.tracks) {
            trackConfig.visible = loadedTrackPaths.contains(trackConfig.url);
        }
        for (TrackConfigContainer container : this.children) {
            container.setTrackVisibility(loadedTrackPaths);
        }
    }
}

