/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.hub;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.igv.Globals;

class Stanza {
    private static Set<String> parentOverrideProperties = new HashSet<String>(Arrays.asList("visibility", "priority", "group"));
    private static final Set<String> nonInheritableProperties = new HashSet<String>(Arrays.asList("track", "type", "shortLabel", "longLabel", "bigDataUrl", "parent", "superTrack", "priority", "compositeTrack", "view", "compositeContainer"));
    final String type;
    final String name;
    private Stanza parent;
    Map<String, String> properties;

    Stanza(String type, String name) {
        this.type = type;
        this.name = name;
        this.properties = new HashMap<String, String>();
    }

    static String firstWord(String str) {
        return Globals.whitespacePattern.split(str)[0];
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    String getOwnProperty(String key) {
        return this.properties.get(key);
    }

    boolean hasOwnProperty(String key) {
        return this.getProperty(key) != null;
    }

    String getProperty(String key) {
        if (this.properties.containsKey("noInherit")) {
            return this.getOwnProperty(key);
        }
        if (parentOverrideProperties.contains(key) && this.parent != null && this.parent.hasProperty(key)) {
            return this.parent.getProperty(key);
        }
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        if (this.parent != null) {
            if (!nonInheritableProperties.contains(key)) {
                return this.parent.getProperty(key);
            }
        }
        return null;
    }

    boolean hasProperty(String key) {
        return this.getProperty(key) != null;
    }

    String format() {
        String type = this.getOwnProperty("type");
        if (type != null) {
            return Stanza.firstWord(type);
        }
        return null;
    }

    public Stanza getParent() {
        return this.parent;
    }

    public void setParent(Stanza parent) {
        if (parent == this) {
            throw new IllegalArgumentException("Stanza cannot be its own parent");
        }
        this.parent = parent;
    }

    public Stanza getAncestor() {
        if (this.parent != null) {
            return this.parent.getAncestor();
        }
        return this;
    }
}

