/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.hub;

import java.util.List;
import javax.swing.table.AbstractTableModel;
import org.igv.ucsc.hub.HubDescriptor;

public class HubTableModel
extends AbstractTableModel {
    private String[] columnHeadings;
    private List<HubDescriptor> records;

    public HubTableModel(List<HubDescriptor> records) {
        this.records = records;
        this.columnHeadings = new String[]{"", "Name", "Description", "DB List", "Info"};
    }

    @Override
    public String getColumnName(int column) {
        return this.columnHeadings[column];
    }

    @Override
    public int getRowCount() {
        return this.records.size();
    }

    @Override
    public int getColumnCount() {
        return this.columnHeadings.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (rowIndex >= this.records.size() || columnIndex >= this.columnHeadings.length) {
            return "";
        }
        HubDescriptor record = this.records.get(rowIndex);
        switch (columnIndex) {
            case 0: {
                return record.isSelected();
            }
            case 1: {
                return record.getShortLabel();
            }
            case 2: {
                return record.getLongLabel();
            }
            case 3: {
                return record.getDbList();
            }
            case 4: {
                return record.getDescriptionUrl();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (columnIndex == 0) {
            this.records.get(rowIndex).setSelected((Boolean)aValue);
        }
    }

    public List<HubDescriptor> getRecords() {
        return this.records;
    }
}

