/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.hub;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.igv.Globals;
import org.igv.feature.genome.load.TrackConfig;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.ucsc.hub.TrackConfigContainer;
import org.igv.ucsc.hub.TrackSelectionDialog;
import org.igv.ucsc.hub.WrapLayout;
import org.igv.ui.FontManager;
import org.igv.ui.util.IconFactory;

public class CollapsiblePanel
extends JPanel {
    private static Logger log = LogManager.getLogger(CollapsiblePanel.class);
    public static final Color HEADER_BG = new Color(180, 204, 226);
    public static final Color HEADER_BG_DARK = HEADER_BG.darker();
    private final JLabel jlabel;
    final List<SelectionBox> selectionBoxes;
    private final boolean autoselectDefaults;
    private final TrackConfigContainer configContainer;
    private JButton collapseButton;
    private JComponent content;
    private JPanel header;
    private ImageIcon openIcon;
    private ImageIcon closeIcon;
    private static Set<String> autoselectTracks = Set.of("ncbiRefSeq", "augustus", "ensGene");

    public CollapsiblePanel(TrackConfigContainer configContainer, boolean autoselectDefaults, boolean addSearchButton) {
        boolean darkMode = Globals.isDarkMode();
        Color backgroundColor = darkMode ? HEADER_BG_DARK : HEADER_BG;
        this.configContainer = configContainer;
        this.autoselectDefaults = autoselectDefaults;
        this.setLayout(new BorderLayout());
        JPanel trackPanel = new JPanel();
        trackPanel.setLayout(new BoxLayout(trackPanel, 1));
        int totalTrackCount = configContainer.countTracks();
        SelectionBox.CheckboxType checkboxType = totalTrackCount < 1000 ? SelectionBox.CheckboxType.SWING : SelectionBox.CheckboxType.CUSTOM;
        this.selectionBoxes = this.addSelectionBoxes(null, configContainer, trackPanel, checkboxType);
        boolean isSelected = false;
        int maxWidth = 0;
        int selectionCount = 0;
        for (SelectionBox selectionBox : this.selectionBoxes) {
            if (selectionBox.isSelected()) {
                ++selectionCount;
                isSelected = true;
            }
            maxWidth = Math.max(maxWidth, selectionBox.getPreferredSize().width);
        }
        for (SelectionBox selectionBox : this.selectionBoxes) {
            selectionBox.setPreferredWidth(maxWidth);
        }
        String label = configContainer.label + "   (" + this.selectionBoxes.size() + " tracks, " + selectionCount + " selected)";
        boolean isOpen = isSelected || configContainer.defaultOpen || this.selectionBoxes.size() <= 100;
        this.content = trackPanel;
        this.openIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.MINUS);
        this.closeIcon = IconFactory.getInstance().getIcon(IconFactory.IconID.PLUS);
        this.content.setVisible(isOpen);
        this.add((Component)this.content, "Center");
        this.header = new JPanel();
        this.header.setLayout(new BorderLayout());
        this.header.setBackground(backgroundColor);
        this.collapseButton = new JButton();
        this.collapseButton.setBackground(backgroundColor);
        this.collapseButton.setBorderPainted(false);
        this.collapseButton.setFocusPainted(false);
        this.collapseButton.setContentAreaFilled(false);
        this.collapseButton.setIcon(isOpen ? this.openIcon : this.closeIcon);
        this.collapseButton.setHorizontalAlignment(2);
        this.collapseButton.addActionListener(e -> {
            this.collapseButton.setIcon(this.content.isVisible() ? this.closeIcon : this.openIcon);
            this.content.setVisible(!this.content.isVisible());
        });
        this.header.add((Component)this.collapseButton, "West");
        this.jlabel = new JLabel(label);
        this.jlabel.setFont(FontManager.getFont(14));
        this.jlabel.setHorizontalAlignment(0);
        if (darkMode) {
            this.jlabel.setForeground(Color.WHITE);
        }
        this.header.add((Component)this.jlabel, "Center");
        this.add((Component)this.header, "North");
        if (addSearchButton) {
            JButton searchButton = TrackSelectionDialog.createSearchButton("Search " + configContainer.label, Arrays.asList(this), selectedCount -> {
                this.updateLabel();
                return null;
            });
            this.addSearchButton(searchButton);
        }
        for (SelectionBox selectionBox : this.selectionBoxes) {
            selectionBox.setCallback(b -> {
                this.updateLabel();
                return null;
            });
        }
    }

    public String containerLabel() {
        return this.configContainer.label;
    }

    public void resetSelectionBoxes(Set<String> loadedTrackPaths) {
        for (SelectionBox box : this.selectionBoxes) {
            boolean isLoaded = loadedTrackPaths != null && loadedTrackPaths.contains(box.trackConfig.url);
            box.setSelected(isLoaded || (loadedTrackPaths == null || loadedTrackPaths.isEmpty()) && this.autoselectDefaults && (autoselectTracks.contains(box.trackConfig.id) || this.selectionBoxes.size() == 1));
            box.setEnabled(this.autoselectDefaults || !isLoaded);
        }
        this.updateLabel();
    }

    public void updateLabel() {
        int count = 0;
        for (SelectionBox selectionBox : this.selectionBoxes) {
            if (!selectionBox.isEnabled() || !selectionBox.isSelected()) continue;
            ++count;
        }
        String label = this.configContainer.label + "   (" + this.selectionBoxes.size() + " tracks, " + count + " selected)";
        this.jlabel.setText(label);
    }

    public void clearSelections() {
        for (SelectionBox box : this.selectionBoxes) {
            if (!box.isEnabled()) continue;
            box.setSelected(false);
        }
        String label = this.configContainer.label + "   (" + this.selectionBoxes.size() + " tracks, 0 selected)";
        this.jlabel.setText(label);
    }

    public List<TrackConfig> getSelectedTracks() {
        return this.selectionBoxes.stream().filter(b -> b.isEnabled() && b.isSelected()).map(SelectionBox::getTrackConfig).toList();
    }

    public void addSearchButton(JComponent searchButton) {
        this.header.add((Component)searchButton, "East");
        this.revalidate();
    }

    public void collapse() {
        this.collapseButton.setIcon(this.closeIcon);
        this.content.setVisible(false);
    }

    public void expand() {
        this.collapseButton.setIcon(this.openIcon);
        this.content.setVisible(true);
    }

    @Override
    public Dimension getMaximumSize() {
        Dimension d4 = this.header.getMinimumSize();
        if (!this.content.isVisible()) {
            return new Dimension(Integer.MAX_VALUE, d4.height);
        }
        Dimension d5 = this.content.getMinimumSize();
        return new Dimension(Integer.MAX_VALUE, d4.height + (int)(1.2 * (double)d5.height));
    }

    private List<SelectionBox> addSelectionBoxes(String labelPrefix, TrackConfigContainer container, JPanel panel, SelectionBox.CheckboxType checkboxType) {
        String title = labelPrefix == null ? "" : labelPrefix + (labelPrefix.length() > 0 ? " - " : "") + container.label;
        ArrayList<SelectionBox> selectionBoxes = new ArrayList<SelectionBox>();
        if (container.tracks.size() > 0) {
            JPanel trackPanel = new JPanel();
            if (labelPrefix != null) {
                trackPanel.setBorder(BorderFactory.createTitledBorder(title));
            }
            WrapLayout wrapLayout = new WrapLayout();
            wrapLayout.setAlignment(0);
            trackPanel.setLayout(wrapLayout);
            for (TrackConfig trackConfig : container.tracks) {
                SelectionBox selectionBox = new SelectionBox(trackConfig, checkboxType);
                trackPanel.add(selectionBox);
                selectionBoxes.add(selectionBox);
            }
            panel.add(Box.createVerticalStrut(5));
            panel.add(trackPanel);
        }
        for (TrackConfigContainer childChild : container.children) {
            selectionBoxes.addAll(this.addSelectionBoxes(title, childChild, panel, checkboxType));
        }
        return selectionBoxes;
    }

    static class SelectionBox
    extends JPanel {
        private final JLabel label;
        private TrackConfig trackConfig;
        private TrackSelectionDialog.CheckBoxWrapper checkbox;
        private int preferredWidth = -1;
        private int minWidth;
        private Function<Integer, Void> callback;

        public SelectionBox(TrackConfig trackConfig, CheckboxType checkboxType) {
            this.setLayout(new BorderLayout(5, 0));
            this.trackConfig = trackConfig;
            String longLabel = trackConfig.longLabel;
            if (longLabel != null) {
                this.setToolTipText(longLabel);
            }
            this.checkbox = new TrackSelectionDialog.CheckBoxWrapper(checkboxType);
            this.checkbox.setActionListener(e -> {
                trackConfig.visible = this.checkbox.isSelected();
                if (this.callback != null) {
                    this.callback.apply(this.checkbox.isSelected() ? 1 : 0);
                }
            });
            this.label = new JLabel(trackConfig.name);
            this.label.setLabelFor(this.checkbox.getComponent());
            this.add((Component)this.checkbox.getComponent(), "West");
            final String infoLink = trackConfig.html;
            if (infoLink == null || "".equals(infoLink.trim())) {
                this.add((Component)this.label, "Center");
            } else {
                ImageIcon icon = IconFactory.getInstance().getIcon(IconFactory.IconID.INFO);
                JLabel iconLabel = new JLabel(icon);
                iconLabel.setToolTipText(infoLink);
                iconLabel.setCursor(Cursor.getPredefinedCursor(12));
                iconLabel.addMouseListener(new MouseAdapter(this){

                    @Override
                    public void mouseClicked(MouseEvent e) {
                        try {
                            Desktop.getDesktop().browse(new URI(infoLink));
                        }
                        catch (Exception ex) {
                            log.error("Error following hyperlink: " + infoLink, ex);
                        }
                    }
                });
                JPanel panel = new JPanel();
                panel.setLayout(new FlowLayout(0, 0, 0));
                panel.add(this.label);
                panel.add(Box.createHorizontalStrut(5));
                panel.add(iconLabel);
                this.add((Component)panel, "Center");
            }
        }

        public void setPreferredWidth(int width) {
            this.minWidth = 200;
            this.preferredWidth = Math.max(this.minWidth, width);
        }

        @Override
        public Dimension getPreferredSize() {
            return this.preferredWidth > 0 ? new Dimension(this.preferredWidth, 20) : super.getPreferredSize();
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        @Override
        public Dimension getMaximumSize() {
            return this.getPreferredSize();
        }

        public void setSelected(boolean selected) {
            this.checkbox.setSelected(selected);
            this.trackConfig.visible = selected;
        }

        @Override
        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.checkbox.setEnabled(enabled);
            this.label.setEnabled(enabled);
        }

        public boolean isSelected() {
            return this.checkbox.isSelected();
        }

        public TrackConfig getTrackConfig() {
            return this.trackConfig;
        }

        public void setCallback(Function<Integer, Void> callback) {
            this.callback = callback;
        }

        static enum CheckboxType {
            SWING,
            CUSTOM;

        }
    }
}

