/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.bb;

import java.io.IOException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.ucsc.twobit.UnsignedByteBuffer;
import org.igv.ucsc.twobit.UnsignedByteBufferImpl;

public class RPTree {
    static int RPTREE_HEADER_SIZE = 48;
    static int RPTREE_NODE_LEAF_ITEM_SIZE = 32;
    static int RPTREE_NODE_CHILD_ITEM_SIZE = 24;
    static int magic = 610839776;
    ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
    Map<Long, Node> nodeCache = new HashMap<Long, Node>();
    long startOffset;
    String path;
    private Header header;
    private long rootNodeOffset;

    static RPTree loadTree(String path, long startOffset) throws IOException {
        RPTree tree = new RPTree(path, startOffset);
        tree.init();
        return tree;
    }

    private RPTree(String path, long startOffset) {
        this.path = path;
        this.startOffset = startOffset;
    }

    void init() throws IOException {
        UnsignedByteBufferImpl binaryParser = UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, this.startOffset, RPTREE_HEADER_SIZE);
        int magic = binaryParser.getInt();
        if (magic != RPTree.magic) {
            this.byteOrder = ByteOrder.BIG_ENDIAN;
            binaryParser = UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, this.startOffset, RPTREE_HEADER_SIZE);
            magic = binaryParser.getInt();
            if (magic != RPTree.magic) {
                throw new RuntimeException("Bad magic number " + magic);
            }
        }
        this.header = new Header(binaryParser);
        this.rootNodeOffset = this.startOffset + (long)RPTREE_HEADER_SIZE;
    }

    List<Item> findLeafItemsOverlapping(int chrIdx1, int startBase, int chrIdx2, int endBase) throws IOException {
        ArrayList<Item> leafItems = new ArrayList<Item>();
        this.walkTree(this.rootNodeOffset, leafItems, chrIdx1, startBase, chrIdx2, endBase);
        return leafItems;
    }

    List<Item> findAllLeafItems() throws IOException {
        ArrayList<Item> leafItems = new ArrayList<Item>();
        this.walkTree(this.rootNodeOffset, leafItems, -1, -1, -1, -1);
        return leafItems;
    }

    void walkTree(long offset, List<Item> leafItems, int chrIdx1, int startBase, int chrIdx2, int endBase) throws IOException {
        Node node = this.readNode(offset);
        for (Item item : node.items) {
            if (chrIdx1 >= 0 && !item.overlaps(chrIdx1, startBase, chrIdx2, endBase)) continue;
            if (node.type == 1) {
                leafItems.add(item);
                continue;
            }
            this.walkTree(item.dataOffset, leafItems, chrIdx1, startBase, chrIdx2, endBase);
        }
    }

    Node readNode(long offset) throws IOException {
        long nodeKey = offset;
        if (this.nodeCache.containsKey(nodeKey)) {
            return this.nodeCache.get(nodeKey);
        }
        UnsignedByteBufferImpl binaryParser = UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, offset, 4);
        byte type = binaryParser.get();
        boolean isLeaf = type == 1;
        byte reserved = binaryParser.get();
        int count = binaryParser.getUShort();
        int bytesRequired = count * (isLeaf ? RPTREE_NODE_LEAF_ITEM_SIZE : RPTREE_NODE_CHILD_ITEM_SIZE);
        binaryParser = UnsignedByteBufferImpl.loadBinaryBuffer(this.path, this.byteOrder, offset + 4L, bytesRequired);
        Item[] items = new Item[count];
        for (int i = 0; i < count; ++i) {
            items[i] = new Item(binaryParser, type);
        }
        Node node = new Node(type, items);
        this.nodeCache.put(nodeKey, node);
        return node;
    }

    static class Header {
        long blockSize;
        long itemCount;
        long startChromIx;
        long startBase;
        long endChromIx;
        long endBase;
        long endFileOffset;
        long itemsPerSlot;
        long reserved;

        Header(UnsignedByteBuffer binaryParser) {
            this.blockSize = binaryParser.getUInt();
            this.itemCount = binaryParser.getLong();
            this.startChromIx = binaryParser.getUInt();
            this.startBase = binaryParser.getUInt();
            this.endChromIx = binaryParser.getUInt();
            this.endBase = binaryParser.getUInt();
            this.endFileOffset = binaryParser.getLong();
            this.itemsPerSlot = binaryParser.getUInt();
            this.reserved = binaryParser.getUInt();
        }
    }

    static class Node {
        int type;
        Item[] items;

        public Node(int type, Item[] items) {
            this.type = type;
            this.items = items;
        }
    }

    static class Item {
        int startChrom;
        int startBase;
        int endChrom;
        int endBase;
        long dataOffset;
        long dataSize;

        Item(UnsignedByteBuffer binaryParser, int type) {
            this.startChrom = binaryParser.getInt();
            this.startBase = binaryParser.getInt();
            this.endChrom = binaryParser.getInt();
            this.endBase = binaryParser.getInt();
            this.dataOffset = binaryParser.getLong();
            if (type == 1) {
                this.dataSize = binaryParser.getLong();
            }
        }

        boolean overlaps(int chrIdx1, int startBase, int chrIdx2, int endBase) {
            return (chrIdx2 > this.startChrom || chrIdx2 == this.startChrom && endBase >= this.startBase) && (chrIdx1 < this.endChrom || chrIdx1 == this.endChrom && startBase <= this.endBase);
        }
    }
}

