/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.bb;

import java.util.ArrayList;
import java.util.List;
import org.igv.Globals;

public class BBUtils {
    public static ASTable parseAutosql(String str) {
        String[] lines;
        ArrayList<ASField> fields = new ArrayList<ASField>();
        boolean startDecoding = false;
        String table = "";
        for (String line : lines = str.trim().split("\\R")) {
            int idx;
            if (line.startsWith("#") || (line = line.trim()).length() <= 0) continue;
            if (line.startsWith("table")) {
                table = line.split("\\s+")[1].trim();
                continue;
            }
            if (line.startsWith("(")) {
                startDecoding = true;
                continue;
            }
            if (line.startsWith(")")) break;
            if (!startDecoding || (idx = line.indexOf(";")) <= 0) continue;
            String[] tokens = Globals.whitespacePattern.split(line.substring(0, idx));
            String description = line.substring(idx + 1).replace("\"", "").trim();
            fields.add(new ASField(tokens[0], tokens[1], description));
        }
        return new ASTable(table, fields);
    }

    public static class ASField {
        public String type;
        public String name;
        public String description;

        public ASField(String type, String name, String description) {
            this.type = type;
            this.name = name;
            this.description = description;
        }
    }

    public static class ASTable {
        public String name;
        public List<ASField> fields;

        public ASTable(String name, List<ASField> fields) {
            this.name = name;
            this.fields = fields;
        }
    }
}

