/*
 * Decompiled with CFR 0.152.
 */
package org.igv.ucsc.bb;

import htsjdk.samtools.util.Locatable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.igv.data.AbstractDataSource;
import org.igv.data.BasicScore;
import org.igv.data.DataSource;
import org.igv.data.DataTile;
import org.igv.feature.Chromosome;
import org.igv.feature.LocusScore;
import org.igv.feature.genome.Genome;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.track.TrackType;
import org.igv.track.WindowFunction;
import org.igv.ucsc.bb.BBFile;
import org.igv.ucsc.bb.BBZoomHeader;

public class BBDataSource
extends AbstractDataSource
implements DataSource {
    private static Logger log = LogManager.getLogger(BBDataSource.class);
    private final Genome genome;
    Collection<WindowFunction> availableWindowFunctions = Arrays.asList(WindowFunction.min, WindowFunction.mean, WindowFunction.max, WindowFunction.none);
    BBFile reader;
    private Map<WindowFunction, List<LocusScore>> wholeGenomeScores;
    private double dataMin = 0.0;
    private double dataMax = 100.0;
    List<LocusScore> wgScores = null;

    public BBDataSource(BBFile reader, Genome genome) throws IOException {
        super(genome);
        this.reader = reader;
        this.genome = genome;
        this.wholeGenomeScores = new HashMap<WindowFunction, List<LocusScore>>();
    }

    @Override
    public double getDataMax() {
        return this.dataMax;
    }

    @Override
    public double getDataMin() {
        return this.dataMin;
    }

    @Override
    protected DataTile getRawData(String chr, int start, int end) {
        try {
            long rTreeOffset = this.reader.getHeader().fullIndexOffset;
            Integer chrIdx = this.reader.getIdForChr(chr);
            if (chrIdx == null) {
                return null;
            }
            List<byte[]> chunks = this.reader.getLeafChunks(chrIdx, start, chrIdx, end, rTreeOffset);
            ArrayList<LocusScore> features = new ArrayList<LocusScore>();
            for (byte[] c : chunks) {
                this.reader.decodeWigData(c, chrIdx, start, end, features);
            }
            int size = features.size();
            int[] starts = new int[size];
            int[] ends = new int[size];
            float[] values = new float[size];
            for (int i = 0; i < size; ++i) {
                LocusScore locusScore = (LocusScore)features.get(i);
                starts[i] = locusScore.getStart();
                ends[i] = locusScore.getEnd();
                values[i] = locusScore.getScore();
            }
            return new DataTile(starts, ends, values, null);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected List<LocusScore> getPrecomputedSummaryScores(String chr, int start, int end, int zoom) {
        try {
            if ("All".equals(chr)) {
                if (this.genome.getHomeChromosome().equals("All") && this.windowFunction != WindowFunction.none) {
                    return this.getWholeGenomeScores();
                }
                return null;
            }
            Chromosome chromosome = this.genome.getChromosome(chr);
            if (chromosome == null) {
                throw new RuntimeException("Unexpected chromosome name: " + chr);
            }
            double nBins = Math.pow(2.0, zoom);
            double scale = (double)chromosome.getLength() / (nBins * 700.0);
            BBZoomHeader zlHeader = this.reader.zoomLevelForScale(scale);
            if (zlHeader == null) {
                return null;
            }
            long rTreeOffset = zlHeader.indexOffset;
            Integer chrIdx = this.reader.getIdForChr(chr);
            if (chrIdx == null) {
                return Collections.EMPTY_LIST;
            }
            List<byte[]> chunks = this.reader.getLeafChunks(chrIdx, start, chrIdx, end, rTreeOffset);
            ArrayList<LocusScore> features = new ArrayList<LocusScore>();
            for (byte[] chunk : chunks) {
                this.reader.decodeZoomData(chr, chunk, chrIdx, start, end, this.windowFunction, features);
            }
            return features;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getLongestFeature(String chr) {
        return 0;
    }

    @Override
    public TrackType getTrackType() {
        return TrackType.OTHER;
    }

    @Override
    public Collection<WindowFunction> getAvailableWindowFunctions() {
        return this.availableWindowFunctions;
    }

    @Override
    public void dispose() {
    }

    private List<LocusScore> getWholeGenomeScores() {
        try {
            if (this.genome.getHomeChromosome().equals("All") && this.windowFunction != WindowFunction.none) {
                if (!this.wholeGenomeScores.containsKey(this.windowFunction)) {
                    int screenWidth = 1000;
                    double scale = this.genome.getWGLength() / (long)screenWidth;
                    List<String> longChromosomeNames = this.genome.getLongChromosomeNames();
                    if (longChromosomeNames.isEmpty()) {
                        return null;
                    }
                    int minID = Integer.MAX_VALUE;
                    int maxID = -1;
                    for (String chr : longChromosomeNames) {
                        Integer id = this.reader.getIdForChr(chr);
                        if (id == null) continue;
                        if (id < minID) {
                            minID = id;
                        }
                        if (id <= maxID) continue;
                        maxID = id;
                    }
                    ArrayList<LocusScore> scores = new ArrayList<LocusScore>();
                    this.wholeGenomeScores.put(this.windowFunction, scores);
                    BBZoomHeader lowestResHeader = this.reader.zoomLevelForScale(scale, 1000);
                    if (lowestResHeader == null) {
                        return null;
                    }
                    HashSet<String> wgChrNames = new HashSet<String>(this.genome.getLongChromosomeNames());
                    long rTreeOffset = lowestResHeader.indexOffset;
                    List<byte[]> chunks = this.reader.getLeafChunks(minID, 0, maxID, Integer.MAX_VALUE, rTreeOffset);
                    ArrayList<LocusScore> features = new ArrayList<LocusScore>();
                    for (byte[] chunk : chunks) {
                        this.reader.decodeZoomData(null, chunk, -1, -1, -1, this.windowFunction, features);
                    }
                    for (LocusScore rec : features) {
                        String chr = this.genome.getCanonicalChrName(rec.getChr());
                        if (!wgChrNames.contains(chr)) continue;
                        int genomeStart = this.genome.getGenomeCoordinate(chr, rec.getStart());
                        int genomeEnd = this.genome.getGenomeCoordinate(chr, rec.getEnd());
                        scores.add(new BasicScore(genomeStart, genomeEnd, rec.getScore()));
                    }
                    scores.sort(Comparator.comparingInt(Locatable::getStart));
                }
                return this.wholeGenomeScores.get(this.windowFunction);
            }
            return null;
        }
        catch (IOException e) {
            log.error("Error getting whole genome scores", e);
            return null;
        }
    }
}

