/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import htsjdk.tribble.Feature;
import java.awt.event.MouseEvent;
import java.util.HashSet;
import java.util.Set;
import org.igv.feature.Exon;
import org.igv.feature.IExon;
import org.igv.feature.IGVFeature;
import org.igv.renderer.SelectableFeatureRenderer;
import org.igv.track.FeatureTrack;
import org.igv.track.TrackClickEvent;

public class SelectableFeatureTrack
extends FeatureTrack {
    protected Set<IExon> selectedExons = new HashSet<IExon>();

    public SelectableFeatureTrack() {
        this.renderer = new SelectableFeatureRenderer();
    }

    public SelectableFeatureTrack(FeatureTrack geneTrack) {
        super(geneTrack);
        this.renderer = new SelectableFeatureRenderer();
    }

    @Override
    public boolean handleDataClick(TrackClickEvent te) {
        MouseEvent e = te.getMouseEvent();
        Feature f = this.getFeatureAtMousePosition(te);
        if (!(e.isShiftDown() || e.isControlDown() || e.isMetaDown())) {
            this.clearSelectedExons();
        }
        boolean foundExon = false;
        if (f != null && f instanceof IGVFeature) {
            this.selectedFeature = (IGVFeature)f;
            double location = te.getFrame().getChromosomePosition(e);
            if (this.selectedFeature.getExons() != null) {
                for (Exon exon : this.selectedFeature.getExons()) {
                    if (!(location >= (double)exon.getStart()) || !(location < (double)exon.getEnd())) continue;
                    this.selectedExons.add(exon);
                    foundExon = true;
                    break;
                }
            }
        }
        ((SelectableFeatureRenderer)this.getRenderer()).setSelectedExons(this.selectedExons);
        return foundExon;
    }

    private void clearSelectedExons() {
        this.selectedExons.clear();
    }

    public Set<IExon> getSelectedExons() {
        return this.selectedExons;
    }
}

