/*
 * Decompiled with CFR 0.152.
 */
package org.igv.track;

import org.igv.feature.CachingFeatureSource;
import org.igv.feature.Strand;
import org.igv.feature.genome.GenomeManager;
import org.igv.tools.motiffinder.MotifFinderSource;
import org.igv.track.FeatureTrack;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class MotifTrack
extends FeatureTrack {
    private String pattern;
    private Strand strand;

    public MotifTrack() {
    }

    public MotifTrack(String name, String pattern, Strand strand) {
        super(null, name, name);
        this.pattern = pattern;
        this.strand = strand;
        this.init();
    }

    private void init() {
        MotifFinderSource src = new MotifFinderSource(this.pattern, this.strand, GenomeManager.getInstance().getCurrentGenome());
        CachingFeatureSource source = new CachingFeatureSource(src);
        super.init(null, source);
        this.setSortable(false);
    }

    @Override
    public void marshalXML(Document document, Element element) {
        element.setAttribute("pattern", this.pattern);
        element.setAttribute("strand", String.valueOf((Object)this.strand));
        super.marshalXML(document, element);
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        this.pattern = element.getAttribute("pattern");
        this.strand = Strand.fromString(element.getAttribute("strand"));
        this.init();
    }
}

