/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.sort;

import htsjdk.samtools.util.CloseableIterator;
import htsjdk.tribble.readers.AsciiLineReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.Comparator;
import org.igv.feature.genome.ChromosomeNameComparator;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.tools.sort.Parser;
import org.igv.tools.sort.SortableRecord;
import org.igv.tools.sort.SortableRecordCodec;
import org.igv.tools.sort.Sorter;
import org.igv.util.collections.SortingCollection;

public abstract class AsciiSorter
implements Sorter {
    private static Logger log = LogManager.getLogger(AsciiSorter.class);
    static int MAX_RECORDS_IN_RAM = 500000;
    protected File inputFile;
    private File outputFile;
    private boolean writeStdOut = false;
    private int maxRecords = MAX_RECORDS_IN_RAM;
    private File tmpDir;
    static final String usageString = "igvtools sort <inputFile> [outputFile]";
    protected Comparator<SortableRecord> comparator = AsciiSorter.getDefaultComparator();

    public AsciiSorter(File inputFile, File outputFile) {
        this.inputFile = inputFile;
        this.outputFile = outputFile;
        this.writeStdOut = outputFile == null;
        this.tmpDir = new File(System.getProperty("java.io.tmpdir"), System.getProperty("user.name"));
        if (!this.tmpDir.exists()) {
            this.tmpDir.mkdir();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() throws IOException {
        FileInputStream fis = null;
        PrintWriter writer = null;
        try {
            fis = new FileInputStream(this.inputFile);
            OutputStreamWriter rawWriter = this.writeStdOut ? new OutputStreamWriter(System.out) : new FileWriter(this.outputFile);
            writer = new PrintWriter(new BufferedWriter(rawWriter));
            SortableRecordCodec codec = new SortableRecordCodec();
            SortingCollection<SortableRecord> cltn = SortingCollection.newInstance(SortableRecord.class, codec, this.comparator, this.maxRecords, this.tmpDir);
            Parser parser = this.getParser();
            AsciiLineReader reader = new AsciiLineReader((InputStream)fis);
            String firstDataRow = this.writeHeader(reader, writer);
            if (firstDataRow != null) {
                cltn.add(parser.createRecord(firstDataRow));
            }
            SortableRecord next = null;
            while ((next = parser.readNextRecord(reader)) != null) {
                cltn.add(next);
            }
            CloseableIterator<SortableRecord> iter = cltn.iterator();
            while (iter.hasNext()) {
                SortableRecord al = (SortableRecord)iter.next();
                writer.println(al.getText());
            }
            iter.close();
        }
        finally {
            if (fis != null) {
                fis.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    @Override
    public void setComparator(Comparator<SortableRecord> comparator) {
        this.comparator = comparator;
    }

    public static Comparator<SortableRecord> getDefaultComparator() {
        Comparator<SortableRecord> comp = new Comparator<SortableRecord>(){
            private Comparator<String> nameComparator = ChromosomeNameComparator.get();

            @Override
            public int compare(SortableRecord o1, SortableRecord o2) {
                int nameComp = this.nameComparator.compare(o1.getChromosome(), o2.getChromosome());
                if (nameComp == 0) {
                    return o1.getStart() - o2.getStart();
                }
                return nameComp;
            }
        };
        return comp;
    }

    abstract Parser getParser() throws IOException;

    abstract String writeHeader(AsciiLineReader var1, PrintWriter var2) throws IOException;

    @Override
    public void setTmpDir(File tmpDir) {
        this.tmpDir = tmpDir;
    }

    @Override
    public void setMaxRecords(int maxRecords) {
        this.maxRecords = maxRecords;
    }

    public void setWriteStdOut(boolean writeStdOut) {
        this.writeStdOut = writeStdOut;
    }
}

