/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.converters;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.igv.tools.parsers.DataConsumer;
import org.igv.tools.parsers.ToolsWiggleParser;
import org.igv.track.TrackType;

public class WigToBed
implements DataConsumer {
    PrintWriter bedWriter;
    double lowerThreshold = 0.1;
    double higherThreshold = 0.3;
    String chr = null;
    int featureStart = -1;
    int featureEnd = -1;
    String type;
    private float score;
    static String upperName = "upper";
    static String lowerName = "lower";

    public static void main(String[] args) throws IOException {
        String input = args[0];
        WigToBed wigToBed = new WigToBed(input, 0.17f, 0.55f);
        ToolsWiggleParser parser = new ToolsWiggleParser(input, wigToBed, null);
        parser.parse();
    }

    public static void run(String inputFile, float hetThreshold, float homThreshold) throws IOException {
        lowerName = String.valueOf((int)(hetThreshold * 10.0f));
        upperName = String.valueOf((int)(homThreshold * 10.0f));
        int len = inputFile.length();
        String outputFile = inputFile.substring(0, len - 4) + ".bed";
        WigToBed wigToBed = new WigToBed(outputFile, hetThreshold, homThreshold);
        ToolsWiggleParser parser = new ToolsWiggleParser(inputFile, wigToBed, null);
        parser.parse();
    }

    public WigToBed(String bedFile, float lowerThreshold, float higherThreshold) {
        this.lowerThreshold = lowerThreshold;
        this.higherThreshold = higherThreshold;
        try {
            this.bedWriter = new PrintWriter(new BufferedWriter(new FileWriter(bedFile)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void addData(String chr, int start, int end, float[] data, String name) {
        if (this.featureStart >= 0) {
            if (start > this.featureEnd || (double)data[0] < this.lowerThreshold) {
                this.writeCurrentFeature();
                this.featureStart = -1;
                this.score = 0.0f;
            }
            this.featureEnd = end;
        }
        if (this.featureStart >= 0) {
            if ((double)data[0] > this.higherThreshold) {
                this.type = String.valueOf(this.higherThreshold);
                this.score = Math.max(this.score, data[0]);
            } else if ((double)data[0] < this.lowerThreshold) {
                this.writeCurrentFeature();
                this.featureStart = -1;
                this.score = 0.0f;
            }
        } else if ((double)data[0] > this.lowerThreshold) {
            this.featureStart = start;
            this.featureEnd = end;
            this.chr = chr;
            this.score = Math.max(this.score, data[0]);
            this.type = (double)data[0] > this.higherThreshold ? String.valueOf(this.higherThreshold) : String.valueOf(this.lowerThreshold);
        }
    }

    private void writeCurrentFeature() {
        this.bedWriter.println(this.chr + "\t" + this.featureStart + "\t" + this.featureEnd + "\t" + this.type);
        this.featureStart = -1;
    }

    @Override
    public void parsingComplete() {
        if (this.featureStart >= 0) {
            this.writeCurrentFeature();
        }
        this.bedWriter.close();
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames) {
    }

    @Override
    public void setTrackParameters(TrackType trackType, String trackLine, String[] trackNames, boolean b) {
    }

    @Override
    public void setSortTolerance(int tolerance) {
    }

    @Override
    public void setAttribute(String key, String value) {
    }

    @Override
    public void setType(String type) {
    }
}

