/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tools.converters;

import htsjdk.samtools.util.CloseableIterator;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import org.igv.sam.Alignment;
import org.igv.sam.ReadMate;
import org.igv.sam.reader.AlignmentReader;
import org.igv.sam.reader.AlignmentReaderFactory;

public class BamToBed {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void convert(File inputBam, File outputBed, boolean properPairs) throws IOException {
        AlignmentReader reader = null;
        CloseableIterator iter = null;
        PrintWriter bedWriter = null;
        int maxInsertSize = 0;
        try {
            bedWriter = new PrintWriter(new BufferedWriter(new FileWriter(outputBed)));
            reader = AlignmentReaderFactory.getReader(inputBam.getAbsolutePath(), false);
            iter = reader.iterator();
            while (iter.hasNext()) {
                Alignment a = (Alignment)iter.next();
                if (!BamToBed.passFilter(a, properPairs)) continue;
                int start = a.getAlignmentStart();
                int insertSize = Math.abs(a.getInferredInsertSize());
                int end = properPairs ? start + insertSize : a.getAlignmentEnd();
                String name = a.getReadName();
                String strand = properPairs ? "." : (a.isNegativeStrand() ? "-" : "+");
                bedWriter.print(a.getChr() + "\t" + start + "\t" + end + "\t" + name + "\t" + strand);
                if (properPairs) {
                    bedWriter.println("\t" + insertSize);
                } else {
                    bedWriter.println();
                }
                maxInsertSize = insertSize > maxInsertSize ? insertSize : maxInsertSize;
            }
        }
        finally {
            if (bedWriter != null) {
                bedWriter.close();
            }
            if (iter != null) {
                iter.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
    }

    private static boolean passFilter(Alignment alignment, boolean properPairs) {
        if (properPairs) {
            ReadMate mate = alignment.getMate();
            if (!alignment.isProperPair() || alignment.getMate() == null || alignment.getStart() > mate.getStart()) {
                return false;
            }
        }
        return alignment.isMapped() && !alignment.isDuplicate() && !alignment.isVendorFailedRead();
    }
}

