/*
 * Decompiled with CFR 0.152.
 */
package org.igv.tdf;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.igv.tdf.BufferedByteWriter;
import org.igv.tdf.TDFTile;

public class TDFVaryTile
implements TDFTile {
    int tileStart;
    double span;
    int[] start;
    float[][] data;

    public TDFVaryTile(ByteBuffer byteBuffer, int nSamples) throws IOException {
        this.fill(byteBuffer, nSamples);
    }

    public TDFVaryTile(int tileStart, double span, int[] start, float[][] data) {
        this.tileStart = tileStart;
        this.span = span;
        this.start = start;
        this.data = data;
    }

    @Override
    public int getSize() {
        return this.start.length;
    }

    @Override
    public int getTileStart() {
        return this.tileStart;
    }

    @Override
    public int getStartPosition(int idx) {
        return this.start[idx];
    }

    @Override
    public int getEndPosition(int idx) {
        return (int)((double)this.start[idx] + this.span);
    }

    @Override
    public String getName(int idx) {
        return null;
    }

    @Override
    public float getValue(int row, int idx) {
        return this.data[row][idx];
    }

    @Override
    public void writeTo(BufferedByteWriter fos) throws IOException {
        int i;
        fos.putNullTerminatedString(TDFTile.Type.variableStep.toString());
        fos.putInt(this.tileStart);
        fos.putFloat((float)this.span);
        int nPositions = this.start.length;
        int nSamples = this.data.length;
        fos.putInt(nPositions);
        for (i = 0; i < nPositions; ++i) {
            fos.putInt(this.start[i]);
        }
        fos.putInt(nSamples);
        for (i = 0; i < this.data.length; ++i) {
            for (int j = 0; j < this.data[i].length; ++j) {
                fos.putFloat(this.data[i][j]);
            }
        }
    }

    public void fill(ByteBuffer byteBuffer, int nSamples) throws IOException {
        this.tileStart = byteBuffer.getInt();
        this.span = byteBuffer.getFloat();
        int nPositions = byteBuffer.getInt();
        this.start = new int[nPositions];
        for (int i = 0; i < nPositions; ++i) {
            this.start[i] = byteBuffer.getInt();
        }
        int nS = byteBuffer.getInt();
        assert (nS == nSamples);
        this.data = new float[nS][nPositions];
        for (int row = 0; row < nS; ++row) {
            this.data[row] = new float[nPositions];
            for (int i = 0; i < nPositions; ++i) {
                this.data[row][i] = byteBuffer.getFloat();
            }
        }
    }

    @Override
    public int[] getStart() {
        return this.start;
    }

    @Override
    public int[] getEnd() {
        int[] end = new int[this.start.length];
        for (int i = 0; i < end.length; ++i) {
            end[i] = (int)((double)this.start[i] + this.span);
        }
        return end;
    }

    @Override
    public float[] getData(int trackNumber) {
        return this.data[trackNumber];
    }

    @Override
    public String[] getNames() {
        return null;
    }
}

