/*
 * Decompiled with CFR 0.152.
 */
package org.igv.session.autosave;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Optional;
import org.igv.DirectoryManager;
import org.igv.prefs.PreferencesManager;
import org.igv.session.Session;
import org.igv.session.SessionWriter;

public class SessionAutosaveManager {
    public static synchronized Optional<File> getExitSessionAutosaveFile() {
        File autosavedSessionFile = new File(DirectoryManager.getAutosaveDirectory(), "exit_session_autosave.xml");
        if (!autosavedSessionFile.exists()) {
            return Optional.empty();
        }
        return Optional.of(autosavedSessionFile);
    }

    public static synchronized void saveExitSessionAutosaveFile(Session session) throws IOException {
        File autosavedSessionFile = new File(DirectoryManager.getAutosaveDirectory(), "exit_session_autosave.xml");
        new SessionWriter().saveSession(session, autosavedSessionFile);
    }

    public static synchronized File[] getTimedSessionAutosaveFiles() {
        File[] autosaveFiles = DirectoryManager.getAutosaveDirectory().listFiles();
        return (File[])Arrays.stream(autosaveFiles).filter(file -> !file.getName().equals("exit_session_autosave.xml")).toArray(File[]::new);
    }

    public static synchronized void saveTimedSessionAutosaveFile(Session session) throws IOException {
        String currentDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'").format(new Date());
        String newAutosaveFilename = "session_autosave" + currentDate + ".xml";
        File autosavedSessionFile = new File(DirectoryManager.getAutosaveDirectory(), newAutosaveFilename);
        autosavedSessionFile.createNewFile();
        Object[] autosaves = SessionAutosaveManager.getTimedSessionAutosaveFiles();
        if (autosaves.length > PreferencesManager.getPreferences().getAsInt("AUTOSAVES_TO_KEEP")) {
            Arrays.sort(autosaves);
            ((File)autosaves[0]).delete();
        }
        new SessionWriter().saveSession(session, autosavedSessionFile);
    }

    public static synchronized Optional<File> getMostRecentAutosaveFile() throws IOException {
        File[] autosaveFiles = DirectoryManager.getAutosaveDirectory().listFiles();
        if (autosaveFiles.length < 1) {
            return Optional.empty();
        }
        int latestIndex = 0;
        long latestCreationTime = Files.readAttributes(autosaveFiles[0].toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
        for (int i = 1; i < autosaveFiles.length; ++i) {
            long currentCreationTime = Files.readAttributes(autosaveFiles[i].toPath(), BasicFileAttributes.class, new LinkOption[0]).creationTime().toMillis();
            if (currentCreationTime <= latestCreationTime) continue;
            latestCreationTime = currentCreationTime;
            latestIndex = i;
        }
        return Optional.of(autosaveFiles[latestIndex]);
    }
}

