/*
 * Decompiled with CFR 0.152.
 */
package org.igv.session.autosave;

import java.io.IOException;
import java.util.TimerTask;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.session.Session;
import org.igv.session.autosave.SessionAutosaveManager;
import org.igv.ui.IGV;
import org.igv.ui.util.MessageUtils;

public class AutosaveTimerTask
extends TimerTask {
    private static Logger log = LogManager.getLogger(AutosaveTimerTask.class);
    private IGV igv;

    public AutosaveTimerTask(IGV igv) {
        this.igv = igv;
    }

    @Override
    public void run() {
        Session session = this.igv.getSession();
        try {
            SessionAutosaveManager.saveTimedSessionAutosaveFile(session);
        }
        catch (IOException err) {
            String message = "Failure while trying to autosave session. Timed autosave will be disabled until IGV is restarted.";
            log.error("Failure while trying to autosave session. Timed autosave will be disabled until IGV is restarted.", err);
            MessageUtils.showMessage("Failure while trying to autosave session. Timed autosave will be disabled until IGV is restarted.\n" + String.valueOf(err));
            this.igv.stopTimedAutosave();
        }
    }
}

