/*
 * Decompiled with CFR 0.152.
 */
package org.igv.session;

import org.igv.renderer.BarChartRenderer;
import org.igv.renderer.DynSeqRenderer;
import org.igv.renderer.FeatureDensityRenderer;
import org.igv.renderer.GeneTrackRenderer;
import org.igv.renderer.GisticTrackRenderer;
import org.igv.renderer.HeatmapRenderer;
import org.igv.renderer.IGVFeatureRenderer;
import org.igv.renderer.LineplotRenderer;
import org.igv.renderer.MutationRenderer;
import org.igv.renderer.PointsRenderer;
import org.igv.renderer.Renderer;

public class RendererFactory {
    static Class defaultRendererClass = BarChartRenderer.class;

    public static Class getRendererClass(String rendererTypeName) {
        String typeName = rendererTypeName.toUpperCase();
        if (typeName.equals(RendererType.BAR_CHART.name()) || typeName.equals("BAR")) {
            return BarChartRenderer.class;
        }
        if (typeName.equals(RendererType.BASIC_FEATURE.name())) {
            return IGVFeatureRenderer.class;
        }
        if (typeName.equals(RendererType.FEATURE_DENSITY.name())) {
            return FeatureDensityRenderer.class;
        }
        if (typeName.equals(RendererType.GENE_TRACK.name())) {
            return GeneTrackRenderer.class;
        }
        if (typeName.equals(RendererType.GISTIC_TRACK.name())) {
            return GisticTrackRenderer.class;
        }
        if (typeName.equals(RendererType.HEATMAP.name())) {
            return HeatmapRenderer.class;
        }
        if (typeName.equals(RendererType.MUTATION.name())) {
            return MutationRenderer.class;
        }
        if (typeName.equals(RendererType.SCATTER_PLOT.name()) || typeName.toUpperCase().equals("POINTS")) {
            return PointsRenderer.class;
        }
        if (typeName.equals(RendererType.LINE_PLOT.name()) || typeName.toUpperCase().equals("LINE")) {
            return LineplotRenderer.class;
        }
        if (typeName.equals(RendererType.DYNSEQ.name())) {
            return DynSeqRenderer.class;
        }
        return null;
    }

    public static RendererType getRenderType(Renderer renderer) {
        Class<?> rendererClass = renderer.getClass();
        RendererType rendererType = null;
        if (rendererClass.equals(BarChartRenderer.class)) {
            rendererType = RendererType.BAR_CHART;
        } else if (rendererClass.equals(IGVFeatureRenderer.class)) {
            rendererType = RendererType.BASIC_FEATURE;
        } else if (rendererClass.equals(FeatureDensityRenderer.class)) {
            rendererType = RendererType.FEATURE_DENSITY;
        } else if (rendererClass.equals(GeneTrackRenderer.class)) {
            rendererType = RendererType.GENE_TRACK;
        } else if (rendererClass.equals(GisticTrackRenderer.class)) {
            rendererType = RendererType.GISTIC_TRACK;
        } else if (rendererClass.equals(HeatmapRenderer.class)) {
            rendererType = RendererType.HEATMAP;
        } else if (rendererClass.equals(MutationRenderer.class)) {
            rendererType = RendererType.MUTATION;
        } else if (rendererClass.equals(PointsRenderer.class)) {
            rendererType = RendererType.SCATTER_PLOT;
        } else if (rendererClass.equals(LineplotRenderer.class)) {
            rendererType = RendererType.LINE_PLOT;
        } else if (rendererClass.equals(DynSeqRenderer.class)) {
            rendererType = RendererType.DYNSEQ;
        }
        return rendererType;
    }

    public static enum RendererType {
        BAR_CHART,
        BASIC_FEATURE,
        FEATURE_DENSITY,
        GENE_TRACK,
        GISTIC_TRACK,
        HEATMAP,
        MUTATION,
        SCATTER_PLOT,
        LINE_PLOT,
        DYNSEQ;

    }
}

