/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sashimi;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import org.igv.Globals;
import org.igv.event.IGVEvent;
import org.igv.event.IGVEventBus;
import org.igv.event.IGVEventObserver;
import org.igv.event.ViewChange;
import org.igv.feature.IExon;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.AlignmentDataManager;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.CoverageTrack;
import org.igv.sam.SpliceJunctionTrack;
import org.igv.sashimi.SashimiContentPane;
import org.igv.sashimi.SashimiJunctionRenderer;
import org.igv.track.FeatureTrack;
import org.igv.track.RenderContext;
import org.igv.track.SelectableFeatureTrack;
import org.igv.track.Track;
import org.igv.track.TrackClickEvent;
import org.igv.track.TrackMenuUtils;
import org.igv.track.WindowFunction;
import org.igv.ui.IGV;
import org.igv.ui.color.ColorPalette;
import org.igv.ui.color.ColorUtilities;
import org.igv.ui.panel.FeatureTrackSelectionDialog;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.PanTool;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.panel.TrackSelectionDialog;
import org.igv.ui.panel.ZoomSliderPanel;
import org.igv.ui.util.IGVMouseInputAdapter;
import org.igv.ui.util.UIUtilities;

public class SashimiPlot
extends JFrame
implements IGVEventObserver {
    private final SashimiContentPane sashimiContentPane;
    private final boolean darkMode = Globals.isDarkMode();
    private final SelectableFeatureTrack featureTrack;
    private List<SpliceJunctionTrack> spliceJunctionTracks;
    private ReferenceFrame referenceFrame;
    private IGVEventBus eventBus;
    private static final List<Color> plotColors;
    private Map<Object, SashimiJunctionRenderer> junctionRendererMap;

    public SashimiPlot(ReferenceFrame iframe, Collection<AlignmentTrack> alignmentTracks, FeatureTrack geneTrack) {
        this.getGlassPane().setCursor(Cursor.getPredefinedCursor(3));
        this.getContentPane().setLayout(new BorderLayout());
        this.setBackground(this.darkMode ? Color.black : Color.white);
        this.eventBus = new IGVEventBus();
        this.referenceFrame = new ReferenceFrame(iframe, this.eventBus);
        int height = IGV.hasInstance() ? IGV.getInstance().getMainFrame().getHeight() : 800;
        this.setSize(this.referenceFrame.getWidthInPixels(), height);
        JPanel controlPanel = this.generateControlPanel(this.referenceFrame);
        controlPanel.setAlignmentX(0.5f);
        this.getContentPane().add((Component)controlPanel, "North");
        JPanel sashimiPanel = new JPanel();
        sashimiPanel.setBackground(this.darkMode ? Color.black : Color.white);
        BoxLayout boxLayout = new BoxLayout(sashimiPanel, 1);
        sashimiPanel.setLayout(boxLayout);
        this.spliceJunctionTracks = new ArrayList<SpliceJunctionTrack>(alignmentTracks.size());
        int colorInd = 0;
        this.junctionRendererMap = new HashMap<Object, SashimiJunctionRenderer>();
        this.eventBus.subscribe(ViewChange.class, this);
        for (AlignmentTrack alignmentTrack : alignmentTracks) {
            AlignmentDataManager dataManager = alignmentTrack.getDataManager();
            SpliceJunctionTrack spliceJunctionTrack = new SpliceJunctionTrack(alignmentTrack.getResourceLocator(), alignmentTrack.getName(), dataManager, alignmentTrack, SpliceJunctionTrack.StrandOption.COMBINE);
            spliceJunctionTrack.setDisplayMode(Track.DisplayMode.COLLAPSED);
            SashimiJunctionRenderer renderer = new SashimiJunctionRenderer();
            spliceJunctionTrack.setRenderer(renderer);
            this.junctionRendererMap.put(spliceJunctionTrack, renderer);
            Color color = plotColors.get(colorInd);
            colorInd = (colorInd + 1) % plotColors.size();
            spliceJunctionTrack.setColor(color);
            TrackComponent<SpliceJunctionTrack> trackComponent = new TrackComponent<SpliceJunctionTrack>(this.referenceFrame, spliceJunctionTrack);
            trackComponent.originalFrame = iframe;
            this.initSpliceJunctionComponent(trackComponent, dataManager, dataManager.getCoverageTrack());
            sashimiPanel.add(trackComponent);
            this.spliceJunctionTracks.add(spliceJunctionTrack);
            spliceJunctionTrack.load(iframe);
        }
        Axis axis = this.createAxis(this.referenceFrame);
        sashimiPanel.add(axis);
        this.featureTrack = new SelectableFeatureTrack(geneTrack);
        TrackComponent<SelectableFeatureTrack> geneComponent = new TrackComponent<SelectableFeatureTrack>(this.referenceFrame, this.featureTrack);
        this.initGeneComponent(this.referenceFrame.getWidthInPixels(), geneComponent, this.featureTrack);
        JScrollPane scrollableGenePane = new JScrollPane(geneComponent);
        scrollableGenePane.setHorizontalScrollBarPolicy(31);
        scrollableGenePane.setVerticalScrollBarPolicy(20);
        this.sashimiContentPane = new SashimiContentPane(sashimiPanel, scrollableGenePane);
        this.sashimiContentPane.setDividerLocation(2 * height / 3);
        this.getContentPane().add(this.sashimiContentPane);
        this.validate();
    }

    private JPanel generateControlPanel(ReferenceFrame frame) {
        JPanel controlPanel = new JPanel();
        ZoomSliderPanel zoomSliderPanel = new ZoomSliderPanel(frame);
        zoomSliderPanel.setMinZoomLevel(frame.getZoom());
        zoomSliderPanel.addMouseListener(new IGVMouseInputAdapter(){

            @Override
            public void igvMouseClicked(MouseEvent e) {
                SashimiPlot.this.repaint();
            }
        });
        Dimension controlSize = new Dimension(200, 30);
        controlPanel.add(zoomSliderPanel);
        SashimiPlot.setFixedSize(zoomSliderPanel, controlSize);
        Dimension panelSize = controlSize;
        SashimiPlot.setFixedSize(controlPanel, panelSize);
        return controlPanel;
    }

    private static void setFixedSize(Component component, Dimension dimension) {
        component.setPreferredSize(dimension);
        component.setMinimumSize(dimension);
        component.setMaximumSize(dimension);
    }

    private Axis createAxis(ReferenceFrame frame) {
        Axis axis = new Axis(frame);
        Dimension maxDim = new Dimension(Integer.MAX_VALUE, 25);
        axis.setMaximumSize(maxDim);
        Dimension prefDim = new Dimension(maxDim);
        prefDim.setSize(frame.getWidthInPixels(), prefDim.height);
        axis.setPreferredSize(prefDim);
        return axis;
    }

    private void initGeneComponent(int prefWidth, TrackComponent<SelectableFeatureTrack> geneComponent, FeatureTrack geneTrack) {
        geneTrack.setDisplayMode(Track.DisplayMode.SQUISHED);
        geneTrack.clearPackedFeatures();
        RenderContext context = new RenderContext(geneComponent, null, this.referenceFrame, null);
        geneTrack.load(context.getReferenceFrame());
        GeneTrackMouseAdapter ad2 = new GeneTrackMouseAdapter(geneComponent);
        geneComponent.addMouseListener(ad2);
        geneComponent.addMouseMotionListener(ad2);
    }

    private void initSpliceJunctionComponent(TrackComponent<SpliceJunctionTrack> trackComponent, AlignmentDataManager dataManager, CoverageTrack coverageTrack) {
        JunctionTrackMouseAdapter ad1 = new JunctionTrackMouseAdapter(trackComponent);
        trackComponent.addMouseListener(ad1);
        trackComponent.addMouseMotionListener(ad1);
        this.getRenderer((SpliceJunctionTrack)trackComponent.track).setDataManager(dataManager);
        this.getRenderer((SpliceJunctionTrack)trackComponent.track).setCoverageTrack(coverageTrack);
        this.getRenderer((SpliceJunctionTrack)trackComponent.track).getCoverageTrack().rescale(trackComponent.originalFrame);
        this.getRenderer((SpliceJunctionTrack)trackComponent.track).setBackground(this.getBackground());
    }

    private SashimiJunctionRenderer getRenderer(SpliceJunctionTrack spliceJunctionTrack) {
        return this.junctionRendererMap.get(spliceJunctionTrack);
    }

    @Override
    public void receiveEvent(IGVEvent event) {
        ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>();
        if (!this.featureTrack.isReadyToPaint(this.referenceFrame)) {
            futures.add(CompletableFuture.runAsync(() -> this.featureTrack.load(this.referenceFrame), IGV.threadExecutor));
        }
        for (SpliceJunctionTrack t : this.spliceJunctionTracks) {
            if (t.isReadyToPaint(this.referenceFrame)) continue;
            futures.add(CompletableFuture.runAsync(() -> t.load(this.referenceFrame), IGV.threadExecutor));
        }
        if (futures.isEmpty()) {
            this.repaint();
        } else {
            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenCompleteAsync((value, throwable) -> this.repaint(), UIUtilities::invokeOnEventThread);
        }
    }

    private void setMaxCoverageDepth(TrackComponent<SpliceJunctionTrack> trackComponent, int newMaxDepth) {
        this.getRenderer((SpliceJunctionTrack)trackComponent.track).setMaxDepth(newMaxDepth);
        this.repaint();
    }

    public static void openSashimiPlot() {
        FeatureTrack geneTrack = null;
        ArrayList<FeatureTrack> nonJunctionTracks = new ArrayList<FeatureTrack>(IGV.getInstance().getFeatureTracks());
        Iterator iter = nonJunctionTracks.iterator();
        while (iter.hasNext()) {
            if (!(iter.next() instanceof SpliceJunctionTrack)) continue;
            iter.remove();
        }
        if (nonJunctionTracks.size() == 1) {
            geneTrack = (FeatureTrack)nonJunctionTracks.get(0);
        } else {
            FeatureTrackSelectionDialog dlg = new FeatureTrackSelectionDialog(IGV.getInstance().getMainFrame(), nonJunctionTracks);
            dlg.setTitle("Select Gene Track");
            dlg.setVisible(true);
            if (dlg.getIsCancelled()) {
                return;
            }
            geneTrack = dlg.getSelectedTrack();
        }
        Collection alignmentTracks = IGV.getInstance().getAlignmentTracks().stream().filter(t -> t.getExperimentType() == AlignmentTrack.ExperimentType.RNA).collect(Collectors.toList());
        if (alignmentTracks.size() > 1) {
            TrackSelectionDialog alDlg = new TrackSelectionDialog(IGV.getInstance().getMainFrame(), TrackSelectionDialog.SelectionMode.MULTIPLE, alignmentTracks);
            alDlg.setTitle("Select Alignment Tracks");
            alDlg.setVisible(true);
            if (alDlg.getIsCancelled()) {
                return;
            }
            alignmentTracks = alDlg.getSelectedTracks();
        }
        SashimiPlot sashimiPlot = new SashimiPlot(FrameManager.getDefaultFrame(), alignmentTracks, geneTrack);
        sashimiPlot.setVisible(true);
    }

    static {
        ColorPalette palette = ColorUtilities.getDefaultPalette();
        plotColors = Arrays.asList(palette.getColors());
    }

    private static class TrackComponent<T extends Track>
    extends JComponent {
        private T track;
        private ReferenceFrame frame;
        private String toolTipText = null;
        public ReferenceFrame originalFrame;

        public TrackComponent(ReferenceFrame frame, T track) {
            this.frame = frame;
            this.track = track;
        }

        public void updateToolTipText(TrackClickEvent tce) {
            this.toolTipText = this.track.getValueStringAt(tce.getFrame().getChrName(), tce.getChromosomePosition(), tce.getMouseEvent().getX(), tce.getMouseEvent().getY(), tce.getFrame());
            this.toolTipText = this.toolTipText == null ? "" : "<html>" + this.toolTipText;
            this.setToolTipText(this.toolTipText);
        }

        @Override
        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle bounds = new Rectangle(this.getBounds());
            bounds.y = 0;
            RenderContext context = new RenderContext(this, (Graphics2D)g, this.frame, bounds);
            this.track.render(context, bounds);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(100, this.track.getHeight());
        }
    }

    private static class Axis
    extends JComponent {
        private ReferenceFrame frame;

        Axis(ReferenceFrame frame) {
            this.frame = frame;
        }

        @Override
        protected void paintComponent(Graphics g) {
            super.paintComponent(g);
            Rectangle visibleRect = this.getVisibleRect();
            RenderContext context = new RenderContext(this, (Graphics2D)g, this.frame, visibleRect);
            this.drawGenomicAxis(context, visibleRect);
        }

        private void drawGenomicAxis(RenderContext context, Rectangle trackRectangle) {
            int numTicks = 4;
            int ticHeight = 5;
            double pixelPadding = trackRectangle.getWidth() / 20.0;
            int yLoc = ticHeight + 1;
            double origin = context.getOrigin();
            double locScale = context.getScale();
            double startPix = trackRectangle.getX() + pixelPadding;
            double endPix = trackRectangle.getMaxX() - pixelPadding;
            double ticIntervalPix = (endPix - startPix) / (double)(numTicks - 1);
            double ticIntervalCoord = locScale * ticIntervalPix;
            int startCoord = (int)(origin + locScale * startPix);
            Graphics2D g2D = context.getGraphic2DForColor(Color.black);
            g2D.drawLine((int)startPix, yLoc, (int)endPix, yLoc);
            for (int tic = 0; tic < numTicks; ++tic) {
                int xLoc = (int)(startPix + (double)tic * ticIntervalPix);
                g2D.drawLine(xLoc, yLoc, xLoc, yLoc - ticHeight);
                int ticCoord = (int)((double)startCoord + (double)tic * ticIntervalCoord);
                String text = "" + ticCoord;
                Rectangle2D textBounds = g2D.getFontMetrics().getStringBounds(text, g2D);
                g2D.drawString(text, (int)((double)xLoc - textBounds.getWidth() / 2.0), (int)((double)yLoc + textBounds.getHeight()));
            }
        }
    }

    private class GeneTrackMouseAdapter
    extends TrackComponentMouseAdapter<SelectableFeatureTrack> {
        GeneTrackMouseAdapter(TrackComponent<SelectableFeatureTrack> trackComponent) {
            super(trackComponent);
        }

        @Override
        protected void handleDataClick(MouseEvent e) {
            ((SelectableFeatureTrack)this.trackComponent.track).handleDataClick(this.createTrackClickEvent(e));
            Set<IExon> selectedExon = ((SelectableFeatureTrack)this.trackComponent.track).getSelectedExons();
            for (SpliceJunctionTrack spliceTrack : SashimiPlot.this.spliceJunctionTracks) {
                SashimiPlot.this.getRenderer(spliceTrack).setSelectedExons(selectedExon);
            }
            SashimiPlot.this.repaint();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.trackComponent.updateToolTipText(this.createTrackClickEvent(e));
        }

        @Override
        protected IGVPopupMenu getPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = new IGVPopupMenu();
            TrackMenuUtils.addDisplayModeItems(Arrays.asList(this.trackComponent.track), menu);
            menu.addPopupMenuListener(new RepaintPopupMenuListener(this.trackComponent));
            return menu;
        }
    }

    private class JunctionTrackMouseAdapter
    extends TrackComponentMouseAdapter<SpliceJunctionTrack> {
        JunctionTrackMouseAdapter(TrackComponent<SpliceJunctionTrack> trackComponent) {
            super(trackComponent);
        }

        @Override
        protected void handleDataClick(MouseEvent e) {
        }

        @Override
        protected IGVPopupMenu getPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = new IGVPopupMenu();
            JCheckBoxMenuItem showCoverageData = new JCheckBoxMenuItem("Show Exon Coverage Data");
            showCoverageData.setSelected(PreferencesManager.getPreferences().getAsBoolean("SASHIMI.SHOW_COVERAGE"));
            showCoverageData.addActionListener(e16 -> {
                PreferencesManager.getPreferences().put("SASHIMI.SHOW_COVERAGE", showCoverageData.isSelected());
                SashimiPlot.this.repaint();
            });
            CoverageTrack covTrack = SashimiPlot.this.getRenderer((SpliceJunctionTrack)this.trackComponent.track).getCoverageTrack();
            covTrack.setWindowFunction(WindowFunction.max);
            JMenuItem setCoverageDataRange = CoverageTrack.addDataRangeItem(SashimiPlot.this, null, Arrays.asList(covTrack));
            setCoverageDataRange.setText("Set Exon Coverage Max");
            JMenuItem maxJunctionCoverageRange = new JMenuItem("Set Junction Coverage Max");
            maxJunctionCoverageRange.setToolTipText("The thickness of each line will be proportional to the coverage, up until this value");
            maxJunctionCoverageRange.addActionListener(e12 -> {
                String input = JOptionPane.showInputDialog(SashimiPlot.this, "Set Max Junction Coverage", SashimiPlot.this.getRenderer((SpliceJunctionTrack)this.trackComponent.track).getMaxDepth());
                if (input == null || input.length() == 0) {
                    return;
                }
                try {
                    int newMaxDepth = Integer.parseInt(input);
                    SashimiPlot.this.setMaxCoverageDepth(this.trackComponent, newMaxDepth);
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(SashimiPlot.this, input + " is not an integer");
                }
            });
            JMenuItem minJunctionCoverageItem = new JMenuItem("Set Junction Coverage Min");
            minJunctionCoverageItem.setToolTipText("Junctions below this threshold will be removed from view");
            minJunctionCoverageItem.addActionListener(e1 -> {
                int minCov = ((SpliceJunctionTrack)this.trackComponent.track).getMinJunctionCoverage();
                String input = JOptionPane.showInputDialog(SashimiPlot.this, "Set Minimum Junction Coverage", minCov);
                if (input == null || input.length() == 0) {
                    return;
                }
                try {
                    int newMinJunctionCoverage = Integer.parseInt(input);
                    ((SpliceJunctionTrack)this.trackComponent.track).setMinJunctionCoverage(newMinJunctionCoverage);
                    this.trackComponent.repaint();
                }
                catch (NumberFormatException ex) {
                    JOptionPane.showMessageDialog(SashimiPlot.this, input + " is not an integer");
                }
            });
            JMenuItem colorItem = new JMenuItem("Set Color");
            colorItem.addActionListener(e15 -> {
                Color color = UIUtilities.showColorChooserDialog("Select Track Color", ((SpliceJunctionTrack)this.trackComponent.track).getColor());
                SashimiPlot.this.toFront();
                if (color == null) {
                    return;
                }
                ((SpliceJunctionTrack)this.trackComponent.track).setColor(color);
                this.trackComponent.repaint();
            });
            ButtonGroup shapeGroup = new ButtonGroup();
            JRadioButtonMenuItem textShape = this.getJunctionCoverageRadioButton("Text", SashimiJunctionRenderer.ShapeType.TEXT);
            textShape.setToolTipText("Show junction coverage as text");
            shapeGroup.add(textShape);
            JRadioButtonMenuItem circleShape = this.getJunctionCoverageRadioButton("Circle", SashimiJunctionRenderer.ShapeType.CIRCLE);
            circleShape.setToolTipText("Show junction coverage as a circle");
            shapeGroup.add(circleShape);
            JRadioButtonMenuItem ellipseShape = this.getJunctionCoverageRadioButton("Ellipse", SashimiJunctionRenderer.ShapeType.ELLIPSE);
            ellipseShape.setToolTipText("Show junction coverage as an ellipse");
            shapeGroup.add(ellipseShape);
            JRadioButtonMenuItem noShape = this.getJunctionCoverageRadioButton("None", SashimiJunctionRenderer.ShapeType.NONE);
            ellipseShape.setToolTipText("Show junction coverage as an ellipse");
            shapeGroup.add(ellipseShape);
            ButtonGroup strandGroup = new ButtonGroup();
            JRadioButtonMenuItem combineStrands = this.getStrandRadioButton("Combine Strands", SpliceJunctionTrack.StrandOption.COMBINE);
            combineStrands.setToolTipText("Combine junctions from both strands -- best for non-strand preserving libraries.");
            strandGroup.add(combineStrands);
            JRadioButtonMenuItem plusStrand = this.getStrandRadioButton("Forward Strand", SpliceJunctionTrack.StrandOption.FORWARD);
            plusStrand.setToolTipText("Show only junctions on the forward read strand  (of first-in-pair for paired reads)");
            strandGroup.add(plusStrand);
            JRadioButtonMenuItem minusStrand = this.getStrandRadioButton("Reverse Strand", SpliceJunctionTrack.StrandOption.REVERSE);
            plusStrand.setToolTipText("Show only junctions on the reverse read strand  (of first-in-pair for paired reads)");
            strandGroup.add(minusStrand);
            JMenuItem savePngImageItem = new JMenuItem("Save PNG Image...");
            savePngImageItem.addActionListener(e13 -> {
                File defaultFile = new File("Sashimi.png");
                IGV.getInstance().createSnapshot(SashimiPlot.this.sashimiContentPane, defaultFile);
            });
            JMenuItem saveSvgImageItem = new JMenuItem("Save SVG Image...");
            saveSvgImageItem.addActionListener(e14 -> {
                File defaultFile = new File("Sashimi.svg");
                IGV.getInstance().createSnapshot(SashimiPlot.this.sashimiContentPane, defaultFile);
            });
            menu.add(new JLabel("Junction Coverage Display"));
            menu.add(setCoverageDataRange);
            menu.add(minJunctionCoverageItem);
            menu.add(maxJunctionCoverageRange);
            menu.add(colorItem);
            menu.add(showCoverageData);
            menu.addSeparator();
            menu.add(textShape);
            menu.add(circleShape);
            menu.add(noShape);
            menu.addSeparator();
            menu.add(combineStrands);
            menu.add(plusStrand);
            menu.add(minusStrand);
            menu.addSeparator();
            menu.add(savePngImageItem);
            menu.add(saveSvgImageItem);
            return menu;
        }

        private JRadioButtonMenuItem getJunctionCoverageRadioButton(String label, final SashimiJunctionRenderer.ShapeType shapeType) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
            item.setSelected(SashimiJunctionRenderer.getShapeType() == shapeType);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SashimiJunctionRenderer.setShapeType(shapeType);
                    SashimiPlot.this.repaint();
                }
            });
            return item;
        }

        private JRadioButtonMenuItem getStrandRadioButton(String label, final SpliceJunctionTrack.StrandOption option) {
            JRadioButtonMenuItem item = new JRadioButtonMenuItem(label);
            item.setSelected(SpliceJunctionTrack.getStrandOption() == option);
            item.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    SpliceJunctionTrack.setStrandOption(option);
                    for (SpliceJunctionTrack t : SashimiPlot.this.spliceJunctionTracks) {
                        t.clear();
                    }
                    SashimiPlot.this.repaint();
                }
            });
            return item;
        }
    }

    private static class RepaintPopupMenuListener
    implements PopupMenuListener {
        Component component;

        RepaintPopupMenuListener(Component component) {
            this.component = component;
        }

        @Override
        public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
            this.component.repaint();
        }

        @Override
        public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
            UIUtilities.invokeOnEventThread(() -> {
                this.component.revalidate();
                this.component.repaint();
            });
        }

        @Override
        public void popupMenuCanceled(PopupMenuEvent e) {
            this.component.repaint();
        }
    }

    private abstract class TrackComponentMouseAdapter<T extends Track>
    extends IGVMouseInputAdapter {
        protected TrackComponent<T> trackComponent;
        protected PanTool currentTool;

        TrackComponentMouseAdapter(TrackComponent<T> trackComponent) {
            this.trackComponent = trackComponent;
            this.currentTool = new PanTool(null);
            this.currentTool.setReferenceFrame(this.trackComponent.frame);
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.currentTool.mouseDragged(e);
            SashimiPlot.this.repaint();
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            super.mouseReleased(e);
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else {
                this.currentTool.mouseReleased(e);
            }
        }

        @Override
        public void mousePressed(MouseEvent e) {
            super.mousePressed(e);
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
            } else {
                this.currentTool.mousePressed(e);
                super.mousePressed(e);
            }
        }

        protected void doPopupMenu(MouseEvent e) {
            IGVPopupMenu menu = this.getPopupMenu(e);
            if (menu != null) {
                menu.show(this.trackComponent, e.getX(), e.getY());
            }
        }

        protected TrackClickEvent createTrackClickEvent(MouseEvent e) {
            return new TrackClickEvent(e, this.trackComponent.frame);
        }

        @Override
        public void igvMouseClicked(MouseEvent e) {
            if (e.isPopupTrigger()) {
                this.doPopupMenu(e);
                return;
            }
            this.currentTool.mouseClicked(e);
            this.handleDataClick(e);
        }

        protected abstract void handleDataClick(MouseEvent var1);

        protected abstract IGVPopupMenu getPopupMenu(MouseEvent var1);
    }
}

