/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam.reader;

import java.io.File;
import javax.swing.JProgressBar;
import org.igv.sam.reader.AlignmentIndexer;
import org.igv.ui.util.IndexCreatorDialog;

public class DotAlignedIndexer
extends AlignmentIndexer {
    int baseOffset = 1;

    public DotAlignedIndexer(File samFile, JProgressBar progressBar, IndexCreatorDialog.SamIndexWorker worker) {
        super(samFile, progressBar, worker);
        if (samFile.getName().endsWith(".bedz") || samFile.getName().endsWith(".bed")) {
            this.baseOffset = 0;
        }
    }

    @Override
    int getAlignmentStart(String[] fields) throws NumberFormatException {
        int position = Integer.parseInt(fields[1]) - this.baseOffset;
        return position;
    }

    @Override
    int getAlignmentLength(String[] fields) throws NumberFormatException {
        return Integer.parseInt(fields[2]) - Integer.parseInt(fields[1]) + 1;
    }

    @Override
    String getChromosome(String[] fields) {
        String chr = fields[0];
        return chr;
    }

    @Override
    boolean isMapped(String[] fields) {
        return true;
    }
}

