/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam.mods;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.IGVPreferences;
import org.igv.prefs.PreferencesManager;
import org.igv.sam.AlignmentTrack;

public class BaseModificationColors {
    private static Logger log = LogManager.getLogger(BaseModificationColors.class);
    static HashMap<String, Color> colors = new HashMap();
    static Map<String, Color> modColorMap = new HashMap<String, Color>();

    public static void updateColors() {
        IGVPreferences preferences = PreferencesManager.getPreferences();
        colors.put("m", preferences.getAsColor("BASEMOD.M_COLOR"));
        colors.put("h", preferences.getAsColor("BASEMOD.H_COLOR"));
        colors.put("o", preferences.getAsColor("BASEMOD.O_COLOR"));
        colors.put("f", preferences.getAsColor("BASEMOD.F_COLOR"));
        colors.put("c", preferences.getAsColor("BASEMOD.C_COLOR"));
        colors.put("g", preferences.getAsColor("BASEMOD.G_COLOR"));
        colors.put("e", preferences.getAsColor("BASEMOD.E_COLOR"));
        colors.put("b", preferences.getAsColor("BASEMOD.B_COLOR"));
        colors.put("a", preferences.getAsColor("BASEMOD.A_COLOR"));
        colors.put("17082", preferences.getAsColor("BASEMOD.17082_COLOR"));
        colors.put("17596", preferences.getAsColor("BASEMOD.17596_COLOR"));
        colors.put("21839", preferences.getAsColor("BASEMOD.21839_COLOR"));
        colors.put("other", preferences.getAsColor("BASEMOD.OTHER_COLOR"));
        colors.put("NONE_A", preferences.getAsColor("BASEMOD.NONE_A_COLOR"));
        colors.put("NONE_C", preferences.getAsColor("BASEMOD.NONE_C_COLOR"));
        colors.put("NONE_U", preferences.getAsColor("BASEMOD.NONE_C_COLOR"));
        colors.put("NONE_T", preferences.getAsColor("BASEMOD.NONE_T_COLOR"));
        colors.put("NONE_G", preferences.getAsColor("BASEMOD.NONE_G_COLOR"));
        colors.put("NONE_N", preferences.getAsColor("BASEMOD.NONE_N_COLOR"));
        modColorMap.clear();
    }

    public static Color getModColor(String modification, int l, AlignmentTrack.ColorOption colorOption) {
        if (colors.isEmpty()) {
            BaseModificationColors.updateColors();
        }
        Color baseColor = BaseModificationColors.getBaseColor(modification);
        String key = modification + l + String.valueOf((Object)colorOption);
        if (!modColorMap.containsKey(key)) {
            int alpha = colorOption == AlignmentTrack.ColorOption.BASE_MODIFICATION_2COLOR ? Math.max(20, Math.min(255, 20 + (int)((float)(l * l) / 50.0f - (float)(4 * l) + 200.0f))) : Math.max(20, (int)Math.min(255.0, 0.006127 * (double)l * (double)l));
            modColorMap.put(key, new Color(baseColor.getRed(), baseColor.getGreen(), baseColor.getBlue(), alpha));
        }
        return modColorMap.get(key);
    }

    private static Color getBaseColor(String modification) {
        if (colors.containsKey(modification)) {
            return colors.get(modification);
        }
        return colors.get("other");
    }
}

