/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import org.apache.commons.math3.stat.Frequency;
import org.igv.feature.IGVFeature;
import org.igv.feature.SpliceJunctionFeature;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.renderer.DataRange;
import org.igv.renderer.GraphicUtils;
import org.igv.renderer.Renderer;
import org.igv.renderer.SpliceJunctionRenderer;
import org.igv.sam.AlignmentDataManager;
import org.igv.sam.AlignmentInterval;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.CoverageTrack;
import org.igv.sam.SpliceJunctionHelper;
import org.igv.sashimi.SashimiPlot;
import org.igv.track.FeatureTrack;
import org.igv.track.PackedFeatures;
import org.igv.track.PackedFeaturesSpliceJunctions;
import org.igv.track.Range;
import org.igv.track.RegionScoreType;
import org.igv.track.RenderContext;
import org.igv.track.ScalableTrack;
import org.igv.track.TrackClickEvent;
import org.igv.track.TrackMenuUtils;
import org.igv.ui.IGV;
import org.igv.ui.panel.IGVPopupMenu;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.util.MessageUtils;
import org.igv.util.ResourceLocator;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SpliceJunctionTrack
extends FeatureTrack
implements ScalableTrack {
    private static Logger log = LogManager.getLogger(SpliceJunctionTrack.class);
    private static StrandOption strandOption;
    private AlignmentTrack alignmentTrack;
    private AlignmentDataManager dataManager;
    private boolean removed = false;

    public static void setStrandOption(StrandOption so) {
        strandOption = so;
    }

    public static StrandOption getStrandOption() {
        return strandOption;
    }

    public SpliceJunctionTrack(ResourceLocator locator, String name, AlignmentDataManager dataManager, AlignmentTrack alignmentTrack, StrandOption ignoreStrand) {
        super(locator, locator.getPath() + "_junctions", name);
        super.setDataRange(new DataRange(0.0f, 0.0f, 60.0f));
        this.renderer = new SpliceJunctionRenderer();
        if (dataManager != null) {
            dataManager.unsubscribe(this);
        }
        this.dataManager = dataManager;
        this.dataManager.subscribe(this);
        this.alignmentTrack = alignmentTrack;
        strandOption = ignoreStrand;
    }

    public SpliceJunctionTrack() {
        this.renderer = new SpliceJunctionRenderer();
    }

    @Override
    public void setRenderer(Renderer renderer) {
        this.renderer = renderer;
    }

    @Override
    public String getSample() {
        if (this.getSampleId() != null) {
            return this.getSampleId();
        }
        return this.alignmentTrack.getSample();
    }

    @Override
    protected boolean isShowFeatures(ReferenceFrame frame) {
        return (double)frame.getCurrentRange().getLength() <= this.dataManager.getVisibilityWindow();
    }

    @Override
    public void render(RenderContext context, Rectangle rect) {
        if (!this.isShowFeatures(context.getReferenceFrame())) {
            Rectangle visibleRect = context.getVisibleRect().intersection(rect);
            Graphics2D g = context.getGraphic2DForColor(Color.gray);
            String message = context.getReferenceFrame().getChrName().equals("All") ? "Select a chromosome and zoom in to see features." : "Zoom in to see features.";
            GraphicUtils.drawCenteredText(message, visibleRect, g);
        } else {
            super.render(context, rect);
        }
    }

    @Override
    public Range getInViewRange(ReferenceFrame referenceFrame) {
        PackedFeatures packedFeatures = (PackedFeatures)this.packedFeaturesMap.get(referenceFrame.getName());
        if (packedFeatures == null) {
            return new Range(0.0f, ((SpliceJunctionRenderer)this.renderer).getMaxDepth());
        }
        Frequency f = new Frequency();
        ArrayList<Integer> scores = new ArrayList<Integer>();
        List featureList = packedFeatures.getFeatures();
        for (IGVFeature feature : featureList) {
            SpliceJunctionFeature junctionFeature = (SpliceJunctionFeature)feature;
            if (!((double)feature.getEnd() >= referenceFrame.getOrigin()) || !((double)feature.getStart() <= referenceFrame.getEnd())) continue;
            f.addValue((Comparable)Float.valueOf(junctionFeature.getScore()));
            scores.add((int)junctionFeature.getScore());
        }
        Collections.sort(scores);
        Collections.reverse(scores);
        int max = 0;
        Iterator iterator = scores.iterator();
        while (iterator.hasNext()) {
            int s = (Integer)iterator.next();
            if (!(f.getCumPct(s) < 0.99)) continue;
            max = s;
            break;
        }
        return new Range(0.0f, max);
    }

    @Override
    public void setDataRange(DataRange axisDefinition) {
        ((SpliceJunctionRenderer)this.renderer).setMaxDepth((int)axisDefinition.getMaximum());
    }

    public boolean isRemoved() {
        return this.removed;
    }

    @Override
    public boolean isVisible() {
        return super.isVisible() && !this.removed;
    }

    public void clear() {
        this.packedFeaturesMap.clear();
    }

    @Override
    public void setVisible(boolean visible) {
        if (visible != this.isVisible()) {
            super.setVisible(visible);
            if (IGV.hasInstance()) {
                IGV.getInstance().getMainPanel().revalidate();
            }
        }
    }

    @Override
    public boolean isLogNormalized() {
        return false;
    }

    @Override
    public float getRegionScore(String chr, int start, int end, int zoom, RegionScoreType type, String frameName) {
        return 0.0f;
    }

    @Override
    protected void renderFeatures(RenderContext context, Rectangle inputRect) {
        AlignmentInterval loadedInterval;
        ReferenceFrame frame = context.getReferenceFrame();
        if (!this.packedFeaturesMap.containsKey(frame.getName()) && (loadedInterval = this.dataManager.getLoadedInterval(frame)) != null) {
            int minJunctionCoverage;
            SpliceJunctionHelper helper = loadedInterval.getSpliceJunctionHelper();
            List<SpliceJunctionFeature> features = helper.getFilteredJunctions(strandOption, minJunctionCoverage = this.alignmentTrack.getRenderOptions().getMinJunctionCoverage());
            if (features == null) {
                features = Collections.emptyList();
            }
            int intervalStart = loadedInterval.getStart();
            int intervalEnd = loadedInterval.getEnd();
            PackedFeaturesSpliceJunctions<SpliceJunctionFeature> pf = new PackedFeaturesSpliceJunctions<SpliceJunctionFeature>(frame.getChrName(), intervalStart, intervalEnd, features.iterator(), this.getDisplayMode());
            this.packedFeaturesMap.put(frame, pf);
        }
        super.renderFeatures(context, inputRect);
    }

    @Override
    public void load(ReferenceFrame frame) {
        this.dataManager.load(frame, this.alignmentTrack.getRenderOptions(), this.alignmentTrack.getDisplayMode(), true);
    }

    @Override
    public boolean isReadyToPaint(ReferenceFrame frame) {
        double extent = frame.getEnd() - frame.getOrigin();
        if (frame.getChrName().equals("All") || extent > this.dataManager.getVisibilityWindow()) {
            return true;
        }
        if (!this.dataManager.isLoaded(frame)) {
            this.packedFeaturesMap.clear();
            return false;
        }
        return true;
    }

    @Override
    public String getExportTrackLine() {
        return "track graphType=junctions";
    }

    public int getMinJunctionCoverage() {
        return this.alignmentTrack.getRenderOptions().getMinJunctionCoverage();
    }

    public void setMinJunctionCoverage(int minJunctionCoverage) {
        this.alignmentTrack.getRenderOptions().setMinJunctionCoverage(minJunctionCoverage);
        this.packedFeaturesMap.clear();
        this.repaint();
    }

    @Override
    public IGVPopupMenu getPopupMenu(TrackClickEvent te) {
        IGVPopupMenu menu = new IGVPopupMenu();
        JLabel popupTitle = new JLabel("  " + this.getName(), 0);
        Font newFont = menu.getFont().deriveFont(1, 12.0f);
        popupTitle.setFont(newFont);
        if (popupTitle != null) {
            menu.add(popupTitle);
        }
        menu.addSeparator();
        TrackMenuUtils.addSharedItems(menu, Collections.singletonList(this));
        menu.addSeparator();
        TrackMenuUtils.addDisplayModeItems(Collections.singletonList(this), menu);
        menu.addSeparator();
        JMenuItem setScaleItem = new JMenuItem("Set Maximum Depth");
        JCheckBoxMenuItem autoscaleItem = new JCheckBoxMenuItem("Autoscale");
        setScaleItem.addActionListener(evt -> {
            Integer newDepth = TrackMenuUtils.getIntegerInput("Maximum Depth", ((SpliceJunctionRenderer)this.renderer).getMaxDepth());
            if (newDepth != null && newDepth > 0) {
                ((SpliceJunctionRenderer)this.renderer).setMaxDepth(newDepth);
                this.setAutoScale(false);
                autoscaleItem.setSelected(false);
                this.repaint();
            }
        });
        menu.add(setScaleItem);
        autoscaleItem.setSelected(this.getAutoScale());
        autoscaleItem.addActionListener(evt -> {
            if (this.getAutoScale()) {
                this.setAutoScale(false);
                autoscaleItem.setSelected(false);
            } else {
                this.setAutoScale(true);
                autoscaleItem.setSelected(true);
            }
            this.repaint();
        });
        menu.add(autoscaleItem);
        JMenuItem minJunctionCoverageItem = new JMenuItem("Set Junction Coverage Min");
        minJunctionCoverageItem.setToolTipText("Junctions below this threshold will be removed from view");
        minJunctionCoverageItem.addActionListener(e1 -> {
            int minCov = this.alignmentTrack.getRenderOptions().getMinJunctionCoverage();
            String input = JOptionPane.showInputDialog("Set Minimum Junction Coverage", (Object)minCov);
            if (input == null || input.length() == 0) {
                return;
            }
            try {
                int newMinJunctionCoverage = Integer.parseInt(input);
                this.setMinJunctionCoverage(newMinJunctionCoverage);
            }
            catch (NumberFormatException ex) {
                MessageUtils.showMessage(input + " is not an integer");
            }
        });
        menu.add(minJunctionCoverageItem);
        menu.addSeparator();
        JMenuItem sashimi = new JMenuItem("Sashimi Plot");
        sashimi.addActionListener(e -> SashimiPlot.openSashimiPlot());
        menu.add(sashimi);
        if (this.alignmentTrack != null) {
            menu.addSeparator();
            CoverageTrack coverageTrack = this.alignmentTrack.getCoverageTrack();
            if (coverageTrack != null) {
                JCheckBoxMenuItem item = new JCheckBoxMenuItem("Show Coverage Track");
                item.setSelected(coverageTrack.isVisible());
                item.setEnabled(!coverageTrack.isRemoved());
                item.addActionListener(e -> {
                    coverageTrack.setVisible(item.isSelected());
                    IGV.getInstance().repaint(Arrays.asList(coverageTrack));
                });
                menu.add(item);
            }
            JCheckBoxMenuItem junctionItem = new JCheckBoxMenuItem("Show Splice Junction Track");
            junctionItem.setSelected(true);
            junctionItem.addActionListener(e -> {
                this.setVisible(junctionItem.isSelected());
                IGV.getInstance().repaint(Arrays.asList(this));
            });
            menu.add(junctionItem);
            if (!(coverageTrack != null && coverageTrack.isVisible() || this.alignmentTrack.isVisible())) {
                junctionItem.setEnabled(false);
            }
            JCheckBoxMenuItem alignmentItem = new JCheckBoxMenuItem("Show Alignment Track");
            alignmentItem.setSelected(this.alignmentTrack.isVisible());
            alignmentItem.setEnabled(!this.alignmentTrack.isRemoved());
            alignmentItem.addActionListener(e -> {
                this.alignmentTrack.setVisible(alignmentItem.isSelected());
                IGV.getInstance().repaint(Arrays.asList(this.alignmentTrack));
            });
            menu.add(alignmentItem);
        }
        return menu;
    }

    @Override
    public void marshalXML(Document document, Element element) {
        super.marshalXML(document, element);
        if (this.removed) {
            element.setAttribute("removed", String.valueOf(this.removed));
        }
        element.setAttribute("autoScale", String.valueOf(this.autoScale));
        element.setAttribute("maxdepth", String.valueOf(((SpliceJunctionRenderer)this.renderer).getMaxDepth()));
    }

    @Override
    public void unmarshalXML(Element element, Integer version) {
        super.unmarshalXML(element, version);
        if (element.hasAttribute("removed")) {
            this.removed = Boolean.parseBoolean(element.getAttribute("removed"));
        }
        if (element.hasAttribute("maxdepth") && this.renderer != null && this.renderer instanceof SpliceJunctionRenderer) {
            ((SpliceJunctionRenderer)this.renderer).setMaxDepth((int)Float.parseFloat(element.getAttribute("maxdepth")));
        }
    }

    public static enum StrandOption {
        COMBINE,
        FORWARD,
        REVERSE,
        BOTH;

    }
}

