/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import htsjdk.samtools.util.Locatable;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import org.igv.feature.genome.ChromosomeNameComparator;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.AlignmentInterval;
import org.igv.sam.Gap;
import org.igv.sam.LinkedAlignment;
import org.igv.sam.Row;

public enum SortOption {
    START{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparingInt(Alignment::getAlignmentStart);
        }
    }
    ,
    STRAND{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return this.nullSafeComparator(a -> a instanceof LinkedAlignment ? ((LinkedAlignment)a).getStrandAtPosition(center) : a.getReadStrand());
        }
    }
    ,
    BASE{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            Comparator<Alignment> insertionComparator = Comparator.comparing(alignment -> {
                AlignmentBlock rightInsertion;
                Object insertionBases = "";
                AlignmentBlock leftInsertion = alignment.getInsertionAt(center + 1);
                if (leftInsertion != null) {
                    insertionBases = (String)insertionBases + leftInsertion.getBases().getString();
                }
                if ((rightInsertion = alignment.getInsertionAt(center)) != null) {
                    insertionBases = (String)insertionBases + rightInsertion.getBases().getString();
                }
                return insertionBases;
            }).reversed();
            int refBase = referenceBase >= 97 ? referenceBase - 32 : referenceBase;
            ToIntFunction<Alignment> baseCompare = a -> {
                int base = a.getBase(center);
                if (base >= 97) {
                    base -= 32;
                }
                if (base == refBase) {
                    base = 0x7FFFFFFC;
                }
                if (base == 78) {
                    base = 0x7FFFFFFD;
                }
                if (base == 0) {
                    base = 97;
                }
                return base;
            };
            Comparator<Alignment> deletionComparator = Comparator.comparing(a -> a.getDeletionAt(center), Comparator.nullsLast(Comparator.comparing(Gap::getnBases).thenComparing(Gap::getStart)));
            ToIntFunction<Alignment> baseQualityCompare = a -> -a.getPhred(center);
            return Comparator.comparingInt(baseCompare).thenComparing(deletionComparator).thenComparing(insertionComparator).thenComparingInt(baseQualityCompare);
        }
    }
    ,
    QUALITY{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparingInt(Alignment::getMappingQuality).reversed();
        }
    }
    ,
    SAMPLE{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return this.nullSafeComparator(Alignment::getSample);
        }
    }
    ,
    READ_GROUP{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return this.nullSafeComparator(Alignment::getReadGroup);
        }
    }
    ,
    INSERT_SIZE{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparingInt(a -> Math.abs(a.getInferredInsertSize())).reversed();
        }
    }
    ,
    FIRST_OF_PAIR_STRAND{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return this.nullSafeComparator(Alignment::getFirstOfPairStrand);
        }
    }
    ,
    MATE_CHR{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(a -> a.getMate() == null).thenComparing(a -> a.getMate() != null && Objects.equals(a.getMate().getChr(), a.getChr())).thenComparing(this.nullSafeComparator(a -> a.getMate() == null ? null : a.getMate().getChr()));
        }
    }
    ,
    TAG{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(a -> a.getAttribute(tag), Comparator.nullsLast(Comparator.comparing(Object::hashCode)));
        }
    }
    ,
    LEFT_CLIP{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(a -> a.getClippingCounts().isLeftClipped()).reversed().thenComparing(Alignment::getAlignmentStart);
        }
    }
    ,
    RIGHT_CLIP{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(a -> a.getClippingCounts().isRightClipped()).reversed().thenComparing(Alignment::getAlignmentEnd);
        }
    }
    ,
    SUPPLEMENTARY{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(Alignment::isSupplementary).reversed();
        }
    }
    ,
    NONE{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return (a1, a2) -> 0;
        }
    }
    ,
    HAPLOTYPE{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparingInt(Alignment::getClusterDistance);
        }
    }
    ,
    READ_ORDER{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(Alignment::isPaired).thenComparing(Alignment::isFirstOfPair).thenComparing(Alignment::isSecondOfPair).reversed();
        }
    }
    ,
    READ_NAME{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparing(Alignment::getReadName);
        }
    }
    ,
    ALIGNED_READ_LENGTH{

        @Override
        Comparator<Alignment> getAlignmentComparator(int center, String tag, byte referenceBase) {
            return Comparator.comparingInt(a -> a.getAlignmentStart() - a.getAlignmentEnd());
        }
    };

    public static final Comparator<Locatable> POSITION_COMPARATOR;

    protected final <T, U extends Comparable<? super U>> Comparator<T> nullSafeComparator(Function<? super T, ? extends U> extractor) {
        return Comparator.comparing(extractor, Comparator.nullsLast(Comparator.naturalOrder()));
    }

    public Comparator<Row> getComparator(int center, byte reference, String tag, boolean invertSort) {
        Comparator<Alignment> alignmentComparator = this.getAlignmentComparator(center, tag, reference);
        if (invertSort) {
            alignmentComparator = alignmentComparator.reversed();
        }
        return Comparator.comparing(row -> AlignmentInterval.getFeatureContaining(row.getAlignments(), center), Comparator.nullsLast(alignmentComparator));
    }

    abstract Comparator<Alignment> getAlignmentComparator(int var1, String var2, byte var3);

    public static SortOption fromString(String name) {
        if (name == null) {
            return NONE;
        }
        if ("NUCLEOTIDE".equals(name)) {
            return BASE;
        }
        return SortOption.valueOf(name);
    }

    static {
        POSITION_COMPARATOR = Comparator.nullsFirst(Comparator.comparing(Locatable::getContig, ChromosomeNameComparator.get())).thenComparing(Locatable::getStart).thenComparing(Locatable::getEnd);
    }
}

