/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;
import org.igv.Globals;
import org.igv.prefs.IGVPreferences;
import org.igv.prefs.PreferencesManager;
import org.igv.ui.color.ColorUtilities;

class NucleotideColors {
    public final Map<Character, Color> nucleotideColors = new HashMap<Character, Color>();

    public NucleotideColors() {
        IGVPreferences prefs = PreferencesManager.getPreferences();
        Color a = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.A"), Color.green);
        Color c = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.C"), Color.blue);
        Color t = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.T"), Color.red);
        Color g = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.G"), new Color(209, 113, 5));
        Color n = ColorUtilities.stringToColor(prefs.get("SAM.COLOR.N"), new Color(64, 64, 64));
        if (Globals.isDarkMode()) {
            if (!prefs.hasExplicitValue("SAM.COLOR.G")) {
                g = g.darker().darker();
            }
            if (!prefs.hasExplicitValue("SAM.COLOR.C")) {
                c = c.brighter().brighter();
            }
        }
        this.nucleotideColors.put(Character.valueOf('A'), a);
        this.nucleotideColors.put(Character.valueOf('a'), a);
        this.nucleotideColors.put(Character.valueOf('C'), c);
        this.nucleotideColors.put(Character.valueOf('c'), c);
        this.nucleotideColors.put(Character.valueOf('T'), t);
        this.nucleotideColors.put(Character.valueOf('t'), t);
        this.nucleotideColors.put(Character.valueOf('G'), g);
        this.nucleotideColors.put(Character.valueOf('g'), g);
        this.nucleotideColors.put(Character.valueOf('N'), n);
        this.nucleotideColors.put(Character.valueOf('n'), n);
        this.nucleotideColors.put(Character.valueOf('-'), Color.black);
    }

    public Color get(char nucleotide) {
        return this.nucleotideColors.getOrDefault(Character.valueOf(nucleotide), Color.black);
    }
}

