/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.awt.Color;
import java.util.List;
import org.igv.feature.LocusScore;
import org.igv.feature.Strand;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.Gap;
import org.igv.track.WindowFunction;

public class DotAlignedAlignment
implements Alignment {
    String readName;
    private String chromosome;
    private int start;
    private int end;
    boolean negativeStrand;

    public DotAlignedAlignment(String chromosome, int start, int end, boolean isNegative, String name) {
        this.negativeStrand = isNegative;
        this.readName = name;
        this.chromosome = chromosome;
        this.start = start;
        this.end = end;
    }

    public DotAlignedAlignment(String chromosome, int start, int end, boolean negativeStrand) {
        this.readName = chromosome + ":" + (start + 1) + "-" + (end + 1) + "(" + (negativeStrand ? "-" : "+") + ")";
        this.chromosome = chromosome;
        this.start = start;
        this.end = end;
        this.negativeStrand = negativeStrand;
    }

    @Override
    public String getReadName() {
        return this.readName;
    }

    @Override
    public void setMateSequence(String sequnce) {
    }

    @Override
    public String getPairOrientation() {
        return "";
    }

    public boolean isSmallInsert() {
        return false;
    }

    @Override
    public boolean isVendorFailedRead() {
        return false;
    }

    @Override
    public Color getYcColor() {
        return null;
    }

    @Override
    public String getChr() {
        return this.chromosome;
    }

    public String getContig() {
        return this.chromosome;
    }

    @Override
    public int getAlignmentStart() {
        return this.getStart();
    }

    @Override
    public boolean contains(double location) {
        return location >= (double)this.getStart() && location < (double)this.getEnd();
    }

    @Override
    public AlignmentBlock[] getAlignmentBlocks() {
        return null;
    }

    @Override
    public AlignmentBlock[] getInsertions() {
        return null;
    }

    @Override
    public int getInferredInsertSize() {
        return 0;
    }

    @Override
    public int getMappingQuality() {
        return 255;
    }

    @Override
    public boolean isProperPair() {
        return true;
    }

    @Override
    public boolean isMapped() {
        return true;
    }

    @Override
    public boolean isPaired() {
        return false;
    }

    @Override
    public boolean isNegativeStrand() {
        return this.negativeStrand;
    }

    @Override
    public boolean isDuplicate() {
        return false;
    }

    @Override
    public float getScore() {
        return 1.0f;
    }

    public LocusScore copy() {
        return this;
    }

    @Override
    public String getValueString(double position, int mouseX, WindowFunction windowFunction) {
        return this.readName + "<br>Read length = " + (this.getEnd() - this.getStart());
    }

    public int getStart() {
        return this.start;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public int getEnd() {
        return this.end;
    }

    @Override
    public int getAlignmentEnd() {
        return this.end;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    @Override
    public byte getBase(double position) {
        return 0;
    }

    @Override
    public byte getPhred(double position) {
        return 0;
    }

    @Override
    public List<Gap> getGaps() {
        return null;
    }

    @Override
    public boolean isFirstOfPair() {
        return false;
    }

    @Override
    public boolean isSecondOfPair() {
        return false;
    }

    @Override
    public Strand getFirstOfPairStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public Strand getSecondOfPairStrand() {
        return Strand.NONE;
    }

    @Override
    public Strand getReadStrand() {
        return this.isNegativeStrand() ? Strand.NEGATIVE : Strand.POSITIVE;
    }

    @Override
    public boolean isPrimary() {
        return true;
    }

    @Override
    public boolean isSupplementary() {
        return false;
    }
}

