/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.sam.AlignmentBlock;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.BaseAlignmentCounts;
import org.igv.sam.ByteSubarray;

public class DenseAlignmentCounts
extends BaseAlignmentCounts {
    private static Logger log = LogManager.getLogger(DenseAlignmentCounts.class);
    private final Set<Byte> nucleotides;
    private final Map<Byte, int[]> posCounts;
    private final Map<Byte, int[]> negCounts;
    private final Map<Byte, int[]> qualities;
    int nPts;
    int[] posTotal;
    int[] negTotal;
    int[] del;
    int[] ins;
    private int[] totalQ;
    private int maxCount = 0;
    protected static int MAX_COUNT_INTERVAL = 100;
    protected int[] maxCounts;

    public DenseAlignmentCounts(int start, int end, AlignmentTrack.BisulfiteContext bisulfiteContext) {
        super(start, end, bisulfiteContext);
        this.nPts = end - start;
        this.nucleotides = new LinkedHashSet<Byte>(List.of(Byte.valueOf((byte)65), Byte.valueOf((byte)84), Byte.valueOf((byte)67), Byte.valueOf((byte)71), Byte.valueOf((byte)78)));
        this.posCounts = new HashMap<Byte, int[]>();
        this.negCounts = new HashMap<Byte, int[]>();
        this.qualities = new HashMap<Byte, int[]>();
        for (byte nt : this.nucleotides) {
            this.posCounts.put(nt, new int[this.nPts]);
            this.negCounts.put(nt, new int[this.nPts]);
            this.qualities.put(nt, new int[this.nPts]);
        }
        this.posTotal = new int[this.nPts];
        this.negTotal = new int[this.nPts];
        this.del = new int[this.nPts];
        this.ins = new int[this.nPts];
        this.totalQ = new int[this.nPts];
        this.maxCounts = new int[this.nPts / MAX_COUNT_INTERVAL + 1];
        log.debug("nPts: " + this.nPts + " maxCounts.length: " + this.maxCounts.length);
    }

    @Override
    public int getNumberOfPoints() {
        return this.end - this.start;
    }

    @Override
    public Set<Byte> getBases() {
        return this.nucleotides;
    }

    @Override
    public int getMaxCount(int strt, int end) {
        if (this.maxCounts == null || this.maxCounts.length == 0) {
            return 1;
        }
        strt = Math.max(0, strt);
        end = Math.min(this.getEnd(), end);
        int startMCI = Math.max(0, (strt - this.start) / MAX_COUNT_INTERVAL);
        int endMCI = Math.max(0, (end - this.start) / MAX_COUNT_INTERVAL);
        endMCI = Math.min(endMCI, this.maxCounts.length - 1);
        int max = 1;
        for (int mci = startMCI; mci <= endMCI; ++mci) {
            if (mci >= this.maxCounts.length) {
                log.error("startMCI index out of range: " + mci + " startMCI=" + startMCI + "  endMCI=" + endMCI);
                return max;
            }
            max = Math.max(max, this.maxCounts[mci]);
        }
        return max;
    }

    @Override
    public void finish() {
    }

    @Override
    public int getTotalCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset] + this.negTotal[offset];
    }

    @Override
    public int getTotalPositiveCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.posTotal[offset];
    }

    @Override
    public int getTotalNegativeCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.negTotal[offset];
    }

    @Override
    public int getTotalQuality(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.totalQ[offset];
    }

    @Override
    public int getCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        if (!this.posCounts.containsKey(b = DenseAlignmentCounts.toUpperCase(b)) || !this.negCounts.containsKey(b)) {
            return 0;
        }
        return this.posCounts.get(b)[offset] + this.negCounts.get(b)[offset];
    }

    @Override
    public int getNegCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        b = DenseAlignmentCounts.toUpperCase(b);
        return this.negCounts.get(b)[offset];
    }

    @Override
    public int getPosCount(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        b = DenseAlignmentCounts.toUpperCase(b);
        return this.posCounts.get(b)[offset];
    }

    @Override
    public int getDelCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.del[offset];
    }

    @Override
    public int getInsCount(int pos) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 0;
        }
        return this.ins[offset];
    }

    @Override
    public int getQuality(int pos, byte b) {
        int offset = pos - this.start;
        if (offset < 0 || offset >= this.nPts) {
            if (log.isDebugEnabled()) {
                log.debug("Position out of range: " + pos + " (valid range - " + this.start + "-" + this.end);
            }
            return 32;
        }
        if (this.qualities.containsKey(b = DenseAlignmentCounts.toUpperCase(b))) {
            return this.qualities.get(b)[offset];
        }
        log.error("Unknown nucleotide: " + b);
        return 0;
    }

    @Override
    protected void incrementDeletion(int pos, boolean negativeStrand) {
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.del.length) {
            this.del[offset] = this.del[offset] + 1;
            if (this.countDeletedBasesCovered) {
                if (negativeStrand) {
                    this.negTotal[offset] = this.negTotal[offset] + 1;
                } else {
                    this.posTotal[offset] = this.posTotal[offset] + 1;
                }
            }
        }
    }

    @Override
    protected void incrementInsertion(AlignmentBlock insBlock) {
        int pos = insBlock.getStart();
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.ins.length) {
            this.ins[offset] = this.ins[offset] + 1;
        }
    }

    @Override
    protected void incBlockCounts(AlignmentBlock block, boolean isNegativeStrand) {
        int start = block.getStart();
        ByteSubarray bases = block.getBases();
        if (bases != null) {
            for (int i = 0; i < bases.length; ++i) {
                int pos = start + i;
                byte q = block.getQuality(i);
                byte n = bases.getByte(i);
                this.incPositionCount(pos, n, q, isNegativeStrand);
            }
        }
    }

    @Override
    protected void incPositionCount(int pos, byte b, byte q, boolean isNegativeStrand) {
        int offset = pos - this.start;
        if (offset >= 0 && offset < this.nPts) {
            if (!this.nucleotides.contains(b = DenseAlignmentCounts.toUpperCase(b))) {
                this.nucleotides.add(b);
                this.posCounts.put(b, new int[this.nPts]);
                this.negCounts.put(b, new int[this.nPts]);
                this.qualities.put(b, new int[this.nPts]);
            }
            if (isNegativeStrand) {
                this.negCounts.get((Object)Byte.valueOf((byte)b))[offset] = this.negCounts.get(b)[offset] + 1;
                this.negTotal[offset] = this.negTotal[offset] + 1;
            } else {
                this.posCounts.get((Object)Byte.valueOf((byte)b))[offset] = this.posCounts.get(b)[offset] + 1;
                this.posTotal[offset] = this.posTotal[offset] + 1;
            }
            this.qualities.get((Object)Byte.valueOf((byte)b))[offset] = this.qualities.get(b)[offset] + q;
            this.totalQ[offset] = this.totalQ[offset] + q;
            int tmp = this.posTotal[offset] + this.negTotal[offset];
            int maxCountInt = offset / MAX_COUNT_INTERVAL;
            if (tmp > this.maxCounts[maxCountInt]) {
                this.maxCounts[maxCountInt] = tmp;
            }
        }
    }

    private static byte toUpperCase(byte b) {
        if (b >= 97 && b <= 122) {
            return (byte)(b - 32);
        }
        return b;
    }
}

