/*
 * Decompiled with CFR 0.152.
 */
package org.igv.sam;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.igv.feature.Locus;
import org.igv.feature.Range;
import org.igv.feature.genome.Genome;
import org.igv.feature.genome.GenomeManager;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.sam.Alignment;
import org.igv.sam.AlignmentCounts;
import org.igv.sam.AlignmentPacker;
import org.igv.sam.AlignmentTrack;
import org.igv.sam.DownsampledInterval;
import org.igv.sam.EmptyAlignmentCounts;
import org.igv.sam.PackedAlignments;
import org.igv.sam.Row;
import org.igv.sam.SortOption;
import org.igv.sam.SpliceJunctionHelper;
import org.igv.track.Track;
import org.igv.ui.panel.ReferenceFrame;

public class AlignmentInterval
extends Locus {
    private static Logger log = LogManager.getLogger(AlignmentInterval.class);
    private ReferenceFrame referenceFrame;
    Genome genome;
    private AlignmentCounts counts;
    private List<Alignment> alignments;
    private SpliceJunctionHelper spliceJunctionHelper;
    private List<DownsampledInterval> downsampledIntervals;
    private PackedAlignments packedAlignments;

    public AlignmentInterval(String chr, int start, int end, List<Alignment> alignments, AlignmentCounts counts, SpliceJunctionHelper spliceJunctionHelper, List<DownsampledInterval> downsampledIntervals, ReferenceFrame frame) {
        super(chr, start, end);
        this.alignments = alignments;
        this.genome = GenomeManager.getInstance().getCurrentGenome();
        this.counts = counts;
        this.spliceJunctionHelper = spliceJunctionHelper;
        this.downsampledIntervals = downsampledIntervals;
        this.referenceFrame = frame;
    }

    public AlignmentInterval(String chr, int start, int end) {
        super(chr, start, end);
        this.alignments = Collections.EMPTY_LIST;
        this.counts = EmptyAlignmentCounts.getInstance();
        this.spliceJunctionHelper = new SpliceJunctionHelper();
        this.downsampledIntervals = Collections.EMPTY_LIST;
    }

    static Alignment getFeatureContaining(List<Alignment> features, int right) {
        int leftBounds = 0;
        int rightBounds = features.size() - 1;
        int idx = features.size() / 2;
        int lastIdx = -1;
        while (idx != lastIdx) {
            lastIdx = idx;
            Alignment f = features.get(idx);
            if (f.contains(right)) {
                return f;
            }
            if (f.getStart() > right) {
                rightBounds = idx;
                idx = (leftBounds + idx) / 2;
                continue;
            }
            leftBounds = idx;
            idx = (rightBounds + idx) / 2;
        }
        if (features.get(0).contains(right)) {
            return features.get(0);
        }
        if (features.get(rightBounds).contains(right)) {
            return features.get(rightBounds);
        }
        return null;
    }

    public void sortRows(SortOption option, double location, String tag, boolean invertSort) {
        PackedAlignments packedAlignments = this.getPackedAlignments();
        if (packedAlignments == null) {
            return;
        }
        int center = (int)location;
        byte referenceBase = this.getReference(center);
        Comparator<Row> rowComparator = option.getComparator(center, referenceBase, tag, invertSort);
        for (List alignmentRows : packedAlignments.values()) {
            alignmentRows.sort(rowComparator);
        }
    }

    public byte getReference(int pos) {
        if (this.genome == null) {
            return 0;
        }
        return this.genome.getReference(this.getChr(), pos);
    }

    public AlignmentCounts getCounts() {
        return this.counts;
    }

    public int getCount(int pos, byte b) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getCount(pos, b);
        }
        return 0;
    }

    public int getMaxCount(int origin, int end) {
        return this.counts.getMaxCount(origin, end);
    }

    public int getTotalCount(int pos) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getTotalCount(pos);
        }
        return 0;
    }

    public int getDelCount(int pos) {
        AlignmentCounts c = this.counts;
        if (pos >= c.getStart() && pos < c.getEnd()) {
            return c.getDelCount(pos);
        }
        return 0;
    }

    public List<Alignment> getAlignments() {
        return this.alignments == null ? Collections.emptyList() : Collections.unmodifiableList(this.alignments);
    }

    public Iterator<Alignment> getAlignmentIterator() {
        return this.alignments == null ? Collections.emptyList().iterator() : this.alignments.iterator();
    }

    public List<DownsampledInterval> getDownsampledIntervals() {
        return this.downsampledIntervals;
    }

    public SpliceJunctionHelper getSpliceJunctionHelper() {
        return this.spliceJunctionHelper;
    }

    public Range getRange() {
        return new Range(this.getChr(), this.getStart(), this.getEnd());
    }

    public void packAlignments(AlignmentTrack.RenderOptions renderOptions, Track.DisplayMode displayMode) {
        AlignmentPacker alignmentPacker = new AlignmentPacker();
        this.packedAlignments = alignmentPacker.packAlignments(this, renderOptions, this.referenceFrame, displayMode);
    }

    public PackedAlignments getPackedAlignments() {
        return this.packedAlignments;
    }

    public void dumpAlignments() {
        if (this.alignments != null) {
            this.alignments.clear();
        }
        this.packedAlignments = null;
    }
}

