/*
 * Decompiled with CFR 0.152.
 */
package org.igv.renderer;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.igv.feature.Cytoband;
import org.igv.ui.FontManager;
import org.igv.ui.panel.FrameManager;
import org.igv.ui.panel.ReferenceFrame;
import org.igv.ui.util.SnapshotUtilities;

public class CytobandRenderer {
    private final boolean darkMode;
    boolean drawLabels = true;
    public static final int CYTOBAND_Y_OFFSET = 5;
    public static final int LABEL_OFFSET = 25;
    private int fontHeight = 10;
    private int bandHeight = 10;
    private String fontFamilyName = "Lucida Sans";
    private static Map<Integer, Color> stainColors = new HashMap<Integer, Color>();

    public CytobandRenderer(boolean darkMode) {
        this.darkMode = darkMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawIdeogram(List<Cytoband> data, Graphics g2D, Rectangle graphicRect, ReferenceFrame frame) {
        if (data.size() > 0) {
            Graphics g = g2D.create();
            try {
                String locus;
                FontManager.getFont(this.fontHeight);
                g.setFont(new Font(this.fontFamilyName, 1, this.fontHeight));
                if (SnapshotUtilities.snapshotInProgress && (locus = frame.getFormattedLocusString()) != null) {
                    Graphics g2 = g2D.create();
                    if (this.darkMode) {
                        g2.setColor(Color.WHITE);
                    }
                    g2.setFont(FontManager.getFont(1, 11));
                    g2.drawString(locus, 3, 11);
                    g2.dispose();
                }
                this.drawBand(data, g, graphicRect, 0.0, frame.getMaxCoordinate());
                if (this.drawLabels && !FrameManager.isGeneListMode()) {
                    this.drawLabels(g, graphicRect, data, 0.0, frame.getMaxCoordinate());
                }
            }
            finally {
                g.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void drawTrack(List<Cytoband> data, Graphics g2D, Rectangle graphicRect, ReferenceFrame frame) {
        if (data.size() > 0) {
            Graphics g = g2D.create();
            try {
                FontManager.getFont(this.fontHeight);
                g.setFont(new Font(this.fontFamilyName, 1, this.fontHeight));
                Rectangle cytoRect = new Rectangle(0, 0, graphicRect.width, 10);
                double start = frame.getOrigin();
                double end = frame.getEnd();
                this.drawBand(data, g, cytoRect, start, end);
                this.drawLabels(g, graphicRect, data, start, end);
            }
            finally {
                g.dispose();
            }
        }
    }

    private void drawBand(List<Cytoband> data, Graphics g2D, Rectangle graphicRect, double start, double end) {
        int[] xC = new int[3];
        int[] yC = new int[3];
        double scale = graphicRect.getWidth() / (end - start);
        int lastPX = -1;
        for (Cytoband cytoband : data) {
            if ((double)cytoband.getEnd() < start) continue;
            if ((double)cytoband.getStart() > end) break;
            int s = (int)(graphicRect.getX() + scale * ((double)cytoband.getStart() - start));
            int e = (int)(graphicRect.getX() + scale * ((double)cytoband.getEnd() - start));
            if (e > lastPX) {
                int y = (int)graphicRect.getY() + 5;
                int height = (int)graphicRect.getHeight();
                if (cytoband.getType() == 'c') {
                    int center = y + height / 2;
                    if (cytoband.getName().startsWith("p")) {
                        xC[0] = s;
                        yC[0] = (int)graphicRect.getMaxY() + 5;
                        xC[1] = s;
                        yC[1] = y;
                        xC[2] = e;
                        yC[2] = center;
                    } else {
                        xC[0] = e;
                        yC[0] = (int)graphicRect.getMaxY() + 5;
                        xC[1] = e;
                        yC[1] = y;
                        xC[2] = s;
                        yC[2] = center;
                    }
                    g2D.setColor(Color.RED.darker());
                    g2D.fillPolygon(xC, yC, 3);
                } else {
                    g2D.setColor(CytobandRenderer.getCytobandColor(cytoband));
                    g2D.fillRect(s, y, e - s, height);
                    g2D.setColor(Color.BLACK);
                    g2D.drawRect(s, y, e - s, height);
                }
            }
            lastPX = e;
        }
    }

    private void drawLabels(Graphics g, Rectangle graphicRect, List<Cytoband> cytobands, double start, double end) {
        double width = graphicRect.getWidth();
        int y = (int)graphicRect.getY() + 25;
        g.setColor(this.darkMode ? Color.white : Color.BLACK);
        FontMetrics fm = g.getFontMetrics();
        int minSpacing = 10;
        int prevEnd = 0;
        double sc = width / (end - start);
        int adjustedY = y;
        if (cytobands != null) {
            for (Cytoband cytoband : cytobands) {
                int stringWidth;
                int e;
                if ((double)cytoband.getEnd() < start) continue;
                if ((double)cytoband.getStart() > end) break;
                int s = (int)(sc * ((double)cytoband.getStart() - start));
                int x = s + ((e = (int)(sc * ((double)cytoband.getEnd() - start))) - s - (stringWidth = (int)fm.getStringBounds(cytoband.getName(), g).getWidth())) / 2;
                if (x <= prevEnd + minSpacing) continue;
                g.drawString(cytoband.getName(), x, adjustedY);
                prevEnd = x + stringWidth;
            }
        }
    }

    public void applyTextTranslationAndRotation(Graphics2D graphics2, int x, int y) {
        AffineTransform transform = new AffineTransform();
        transform.translate(x, y);
        transform.rotate(-1.5707963267948966);
        graphics2.transform(transform);
    }

    private static Color getCytobandColor(Cytoband data) {
        if (data.getType() == 'p') {
            short stain = data.getStain();
            int shade = (int)(255.0 - (double)stain / 100.0 * 255.0);
            Color c = stainColors.get(shade);
            if (c == null) {
                c = new Color(shade, shade, shade);
                stainColors.put(shade, c);
            }
            return c;
        }
        if (data.getType() == 'c') {
            return Color.PINK;
        }
        return Color.WHITE;
    }
}

