/*
 * Decompiled with CFR 0.152.
 */
package org.igv.prefs;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.MouseEvent;
import java.text.DecimalFormat;
import javax.swing.JPanel;
import javax.swing.event.MouseInputListener;
import org.igv.Globals;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;
import org.igv.renderer.ContinuousColorScale;
import org.igv.ui.FontManager;
import org.igv.ui.IGV;
import org.igv.ui.legend.HeatmapLegendEditor;
import org.igv.ui.util.IGVMouseInputAdapter;
import org.igv.ui.util.UIUtilities;

public class LegendPanel
extends JPanel {
    static Logger log = LogManager.getLogger(LegendPanel.class);
    private Orientation orientation = Orientation.HORIZONTAL;
    private String key;
    protected ContinuousColorScale colorScale;
    private MouseInputListener mouseListener;

    public LegendPanel(String key) {
        this.key = key;
        this.colorScale = PreferencesManager.getPreferences().getColorScale(key);
        this.mouseListener = new IGVMouseInputAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                LegendPanel.this.setCursor(Cursor.getPredefinedCursor(12));
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void igvMouseClicked(MouseEvent e) {
                LegendPanel.this.edit();
            }
        };
        this.addMouseListener(this.mouseListener);
        UIUtilities.invokeOnEventThread(() -> this.setToolTipText("Click this item bring up its editor"));
    }

    public void edit() {
        UIUtilities.invokeOnEventThread(() -> {
            IGV.getInstance().setStatusBarMessage("Setting view properties...");
            HeatmapLegendEditor dialog = new HeatmapLegendEditor(IGV.getInstance().getMainFrame(), true, this.colorScale);
            dialog.setTitle("HeatMap Preferences");
            dialog.setVisible(true);
            if (dialog.isCanceled()) {
                IGV.getInstance().resetStatusMessage();
                return;
            }
            this.colorScale = dialog.getColorScheme();
            PreferencesManager.getPreferences().setColorScale(this.key, this.colorScale);
            this.repaint();
            IGV.getInstance().repaint();
        });
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (PreferencesManager.getPreferences().getAntiAliasing()) {
            ((Graphics2D)g).setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        }
        this.paintLegend((Graphics2D)g);
    }

    protected void paintLegend(Graphics2D g) {
        if (this.orientation == Orientation.HORIZONTAL) {
            this.paintHorizontal(g);
        } else {
            this.paintVertical(g);
        }
    }

    protected void paintHorizontal(Graphics2D g2D) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        g2D.setFont(FontManager.getFont(10));
        int npts = 5;
        double max = this.colorScale.getMaximum();
        double min = this.colorScale.getMinimum();
        int w = this.getWidth() - 20;
        double dx = (double)w / (double)npts;
        double dxj = dx / 10.0;
        double delta = (max - min) / (double)npts;
        double deltaj = delta / 10.0;
        for (int i = 0; i < npts + 1; ++i) {
            for (int j = i * 10; j < i * 10 + 10; ++j) {
                double val = min + (double)j * deltaj;
                Color c = this.colorScale.getColor((float)val);
                g2D.setColor(c);
                int x0 = (int)((double)j * dxj);
                int x1 = (int)((double)(j + 1) * dxj);
                g2D.fillRect(x0, 0, x1 - x0, this.getHeight() / 2);
            }
            double labelVal = min + (double)i * delta;
            int x0 = (int)((double)i * dx);
            g2D.setColor(Globals.isDarkMode() ? Color.WHITE : Color.BLACK);
            g2D.drawString(formatter.format(labelVal), x0, this.getHeight() - 5);
        }
    }

    void paintVertical(Graphics2D g2D) {
        DecimalFormat formatter = new DecimalFormat("0.0");
        g2D.setFont(FontManager.getFont(10));
        int npts = 5;
        double max = this.colorScale.getMaximum();
        double min = this.colorScale.getMinimum();
        int h = this.getWidth() - 20;
        double dy = (double)h / (double)npts;
        double dyj = dy / 10.0;
        double delta = (max - min) / (double)npts;
        double deltaj = delta / 10.0;
        int x0 = 10;
        int dx = 10;
        int y1 = 0;
        for (int i = 0; i < npts + 1; ++i) {
            for (int j = i * 10; j < i * 10 + 10; ++j) {
                double val = min + (double)j * deltaj;
                Color c = this.colorScale.getColor((float)val);
                g2D.setColor(c);
                int y0 = (int)((double)j * dyj);
                y1 = (int)((double)(j + 1) * dyj);
                g2D.fillRect(x0, y0, dx, y1 - y0);
            }
            double labelVal = min + (double)i * delta;
            g2D.setColor(Color.BLACK);
            g2D.drawString(formatter.format(labelVal), x0 + 15, y1 - 5);
        }
    }

    static enum Orientation {
        HORIZONTAL,
        VERTICAL;

    }
}

