/*
 * Decompiled with CFR 0.152.
 */
package org.igv.oauth;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.BindException;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.oauth.OAuthProvider;
import org.igv.ui.util.MessageUtils;
import org.igv.util.StringUtils;

public class OauthListener
implements Runnable {
    private static Logger log = LogManager.getLogger(OauthListener.class);
    private static final String CRLF = "\r\n";
    private int port;
    private OAuthProvider provider;
    private Thread listenerThread;
    private static final String HTTP_RESPONSE = "HTTP/1.1 200 OK";
    private static final String HTTP_NO_RESPONSE = "HTTP/1.1 204 No Response";
    private static final String CONNECTION_CLOSE = "Connection: close";
    private static final String NO_CACHE = "Cache-Control: no-cache, no-store";
    private static final String ACCESS_CONTROL_ALLOW_ORIGIN = "Access-Control-Allow-Origin: *";

    public static synchronized void start(int port, OAuthProvider provider) {
        OauthListener listener = null;
        try {
            listener = new OauthListener(port, provider);
            listener.listenerThread.start();
        }
        catch (Exception e) {
            log.error(e);
        }
    }

    private OauthListener(int port, OAuthProvider provider) {
        this.port = port;
        this.provider = provider;
        this.listenerThread = new Thread(this);
    }

    @Override
    public void run() {
        try (ServerSocket serverSocket = new ServerSocket(this.port);
             Socket clientSocket = serverSocket.accept();){
            PrintWriter out = new PrintWriter(clientSocket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
            String inputLine = in.readLine();
            String nextLine = in.readLine();
            while (nextLine != null && nextLine.length() > 0) {
                nextLine = in.readLine();
            }
            String[] tokens = inputLine.split(" ");
            if (tokens.length < 2) {
                this.sendTextResponse(out, "ERROR unexpected oauth request: " + inputLine);
            } else {
                HashMap params;
                String[] parts = tokens[1].split("\\?");
                Map<Object, Object> map = params = parts.length < 2 ? new HashMap() : this.parseParameters(parts[1]);
                if (params.containsKey("error")) {
                    this.sendTextResponse(out, "Error authorizing IGV: " + (String)params.get("error"));
                } else if (params.containsKey("code")) {
                    this.provider.fetchAccessToken((String)params.get("code"));
                    this.sendTextResponse(out, "Authorization successful.  You may close this tab.");
                } else {
                    this.sendTextResponse(out, "Unsuccessful authorization response: " + inputLine);
                }
            }
        }
        catch (BindException e) {
            MessageUtils.showErrorMessage("Error opening listener for oAuth authorization", e);
        }
        catch (Exception e) {
            MessageUtils.showErrorMessage("Error opening listener for oAuth authorization", e);
            log.error(e);
        }
    }

    private void sendTextResponse(PrintWriter out, String result) {
        this.sendHTTPResponse(out, result, "text/html", "GET");
    }

    private void sendHTTPResponse(PrintWriter out, String result, String contentType, String method) {
        out.print(result == null ? HTTP_NO_RESPONSE : HTTP_RESPONSE);
        out.print(CRLF);
        out.print(ACCESS_CONTROL_ALLOW_ORIGIN);
        out.print(CRLF);
        if (result != null) {
            out.print("Content-Type: " + contentType);
            out.print(CRLF);
            out.print("Content-Length: " + result.length());
            out.print(CRLF);
            out.print(NO_CACHE);
            out.print(CRLF);
            out.print(CONNECTION_CLOSE);
            out.print(CRLF);
            if (!method.equals("HEAD")) {
                out.print(CRLF);
                out.print(result);
                out.print(CRLF);
            }
        } else {
            out.print(CRLF);
        }
        out.close();
    }

    private Map<String, String> parseParameters(String parameterString) {
        String[] kvPairs;
        parameterString = parameterString.replace("&amp;", "&");
        HashMap<String, String> params = new HashMap<String, String>();
        for (String kvString : kvPairs = parameterString.split("&")) {
            String[] kv = kvString.split("=", 2);
            if (kv.length == 1) {
                params.put(kv[0], null);
                continue;
            }
            String key = StringUtils.decodeURL(kv[0]);
            String value = StringUtils.decodeURL(kv[1]);
            params.put(key, value);
        }
        return params;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int findFreePort() {
        int port = 49152;
        while (port < 65536) {
            try (ServerSocket serverSocket = new ServerSocket(port);){
                if (serverSocket != null && serverSocket.getLocalPort() == port) {
                    int n = port;
                    return n;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++port;
        }
        return -1;
    }
}

