/*
 * Decompiled with CFR 0.152.
 */
package org.igv.jbrowse;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;
import java.net.UnknownHostException;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.prefs.PreferencesManager;

class CircviewSocketWriter {
    static Logger log = LogManager.getLogger(CircviewSocketWriter.class);

    CircviewSocketWriter() {
    }

    static String send(String json) {
        return CircviewSocketWriter.send(json, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String send(String json, boolean suppressErrors) {
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader in = null;
        try {
            String response;
            String host = PreferencesManager.getPreferences().get("CIRC_VIEW_HOST");
            int port = PreferencesManager.getPreferences().getAsInt("CIRC_VIEW_PORT");
            socket = new Socket(host, port);
            out = new PrintWriter(socket.getOutputStream(), true);
            in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(json);
            out.flush();
            String string = response = in.readLine();
            return string;
        }
        catch (UnknownHostException e) {
            String err = "Unknown host exception: " + e.getMessage();
            if (!suppressErrors) {
                log.error(e);
            }
            String string = err;
            return string;
        }
        catch (IOException e) {
            String message = "IO Exception: " + e.getMessage();
            if (!suppressErrors) {
                log.error(message, e);
            }
            String string = message;
            return string;
        }
        finally {
            try {
                in.close();
                out.close();
                socket.close();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }
}

