/*
 * Decompiled with CFR 0.152.
 */
package org.igv.htsget;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import org.igv.util.HttpUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class HtsgetUtils {
    public static Metadata getMetadata(String url) throws IOException {
        JSONObject json;
        if (url.startsWith("htsget://")) {
            try {
                return HtsgetUtils.getMetadata(url.replace("htsget://", "https://"));
            }
            catch (IOException e) {
                return HtsgetUtils.getMetadata(url.replace("htsget://", "http://"));
            }
        }
        URL headerURL = HtsgetUtils.addQueryString(url, "class=header");
        String ticket = HttpUtils.getInstance().getContentsAsJSON(headerURL);
        try {
            json = new JSONObject(ticket);
        }
        catch (JSONException e) {
            return null;
        }
        if (!json.has("htsget")) {
            return null;
        }
        String format = json.getJSONObject("htsget").getString("format");
        return new Metadata(url, format);
    }

    static URL addQueryString(String urlBase, String queryString) throws MalformedURLException {
        String separator = urlBase.contains("?") ? "&" : "?";
        return new URL(urlBase + separator + queryString);
    }

    public static class Metadata {
        private final String url;
        private final String format;

        public Metadata(String url, String format) {
            this.url = url;
            this.format = format;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFormat() {
            return this.format;
        }
    }
}

