/*
 * Decompiled with CFR 0.152.
 */
package org.igv.gwas;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.regex.Pattern;
import org.igv.Globals;
import org.igv.exceptions.ParserException;
import org.igv.feature.genome.Genome;
import org.igv.gwas.GWASData;
import org.igv.gwas.GWASFeature;
import org.igv.logging.LogManager;
import org.igv.logging.Logger;
import org.igv.util.ParsingUtils;
import org.igv.util.ResourceLocator;

public class GWASParser {
    private static final Logger log = LogManager.getLogger(GWASParser.class);
    private ResourceLocator locator;
    Genome genome;
    private GWASColumns columns;
    public Pattern delimiter;
    private int warningCount;
    private static int MAX_WARNING = 20;

    public static boolean isGWASFile(String typeString) {
        return typeString.endsWith("logistic") || typeString.endsWith("linear") || typeString.endsWith("assoc") || typeString.endsWith("qassoc") || typeString.endsWith("gwas");
    }

    public GWASParser(ResourceLocator locator, Genome genome) {
        this.locator = locator;
        this.genome = genome;
        this.columns = new GWASColumns();
        this.warningCount = 0;
    }

    public String[] getColumnHeaders() {
        return this.columns.columnHeaders;
    }

    public GWASData parse() throws IOException {
        BufferedReader reader = null;
        String nextLine = null;
        int rowCounter = 0;
        GWASData data = new GWASData();
        try {
            reader = ParsingUtils.openBufferedReader(this.locator);
            String headerLine = reader.readLine();
            Pattern pattern = this.delimiter = headerLine.indexOf(9) > 0 ? Globals.tabPattern : Globals.whitespacePattern;
            if (!this.columns.parseHeader(headerLine, this.delimiter)) {
                throw new ParserException("Error while parsing header line.", 0L, nextLine);
            }
            while ((nextLine = reader.readLine()) != null && nextLine.trim().length() > 0) {
                GWASFeature f = this.parseLine(nextLine = nextLine.trim(), ++rowCounter);
                if (f == null) continue;
                data.addFeature(f);
            }
            data.finish();
            GWASData gWASData = data;
            return gWASData;
        }
        catch (Exception e) {
            if (nextLine != null && rowCounter != 0) {
                throw new ParserException(e.getMessage(), (Throwable)e, rowCounter, nextLine);
            }
            throw new RuntimeException(e);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private GWASFeature parseLine(String nextLine, long lineNumber) {
        String[] tokens = this.delimiter.split(nextLine);
        if (tokens.length >= 3) {
            int position;
            String posString = tokens[this.columns.locationCol].trim();
            if (posString.indexOf(";") > 0 || posString.length() == 0 || posString.indexOf(120) > 0) {
                if (this.warningCount < MAX_WARNING) {
                    log.warn(this.locator.getFileName() + " line number: " + lineNumber + ".  expected numeric position at column " + this.columns.locationCol + " Found " + tokens[this.columns.locationCol]);
                } else if (this.warningCount == MAX_WARNING) {
                    log.warn("Max warning count excedeed for " + this.locator.getPath());
                }
                ++this.warningCount;
                return null;
            }
            String chr = tokens[this.columns.chrCol].trim();
            if (this.genome != null) {
                chr = this.genome.getCanonicalChrName(chr);
            }
            try {
                position = Integer.parseInt(posString);
            }
            catch (NumberFormatException e) {
                if (this.warningCount < MAX_WARNING) {
                    log.warn(this.locator.getFileName() + " line number: " + lineNumber + ".  expected numeric position at column " + this.columns.locationCol + " Found " + tokens[this.columns.locationCol]);
                } else if (this.warningCount == MAX_WARNING) {
                    log.warn("Max warning count excedeed for " + this.locator.getPath());
                }
                ++this.warningCount;
                return null;
            }
            if (!tokens[this.columns.pCol].trim().equalsIgnoreCase("NA")) {
                double p = 0.0;
                try {
                    int exp;
                    String pvalString = tokens[this.columns.pCol];
                    int idx = pvalString.indexOf("E");
                    if (idx > 0 && (double)(exp = Integer.parseInt(pvalString.substring(idx + 1))) < Math.log10(Double.MIN_VALUE)) {
                        p = -1 * exp;
                    }
                    if (p == 0.0) {
                        p = Double.parseDouble(tokens[this.columns.pCol]);
                        if (p <= 0.0) {
                            throw new NumberFormatException();
                        }
                        p = -Math.log10(p);
                    }
                }
                catch (NumberFormatException e) {
                    log.warn("Error parsing line number " + lineNumber + ". Column " + this.columns.pCol + " must be a positive numeric value. Found " + tokens[this.columns.pCol]);
                    return null;
                }
                return new GWASFeature(chr, position, p, nextLine);
            }
        }
        return null;
    }

    public static class GWASColumns {
        public int locationCol = 2;
        public int chrCol = 1;
        public int pCol = 3;
        public int SNPCol = 0;
        private String[] columnHeaders;

        public boolean hasAllFields() {
            return this.locationCol >= 0 || this.chrCol >= 0 || this.pCol >= 0 || this.SNPCol >= 0;
        }

        public boolean parseHeader(String headerString, Pattern delimiter) {
            try {
                headerString = headerString.trim();
                String[] headers = delimiter.split(headerString);
                this.columnHeaders = headers;
                int headersSize = headers.length;
                if (headersSize < 4) {
                    return false;
                }
                for (int colCounter = 0; colCounter < headersSize; ++colCounter) {
                    String header = headers[colCounter];
                    if ((header = header.toLowerCase()).equals("chr") || header.equals("chromosome") || header.equals("chr_id")) {
                        this.chrCol = colCounter;
                    }
                    if (header.equals("bp") || header.equals("pos") || header.equals("position") || header.equals("chr_pos")) {
                        this.locationCol = colCounter;
                    }
                    if (header.equals("p") || header.equals("pval") || header.equals("p-value") || header.equals("pvalue") || header.equals("p.value")) {
                        this.pCol = colCounter;
                    }
                    if (!header.equals("snp") && !header.equals("snps") && !header.equals("rs") && !header.equals("rsid") && !header.equals("rsnum") && !header.equals("id") && !header.equals("marker") && !header.equals("markername")) continue;
                    this.SNPCol = colCounter;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return this.hasAllFields();
        }
    }
}

